<?php
/**
 * Win32 Ŭ 
 *
 * @package php.ui.winbinder.win32
 */

/**
 * FreeImage ̺귯 Ŭ 
 * 
 * @package php.ui.winbinder.win32
 */
class WBFreeImage extends WBLibrary { 

	const UNKNOWN	= -1;
	const BMP		= 0;
	const ICO		= 1;
	const JPEG		= 2;
	const JNG		= 3;
	const KOALA		= 4;
	const LBM		= 5;
	const IFF		= 5;
	const MNG		= 6;
	const PBM		= 7;
	const PBMRAW	= 8;
	const PCD		= 9;
	const PCX		= 10;
	const PGM		= 11;
	const PGMRAW	= 12;
	const PNG		= 13;
	const PPM		= 14;
	const PPMRAW	= 15;
	const RAS		= 16;
	const TARGA		= 17;
	const TIFF		= 18;
	const WBMP		= 19;
	const PSD		= 20;
	const CUT		= 21;
	const XBM		= 22;
	const XPM		= 23;
	const DDS		= 24;
	const GIF		= 25;

	public function __construct()  { 
		parent::__construct('ext\\freeimage');
	}

	/**
	 * version  
	 * 
	 * @return string
	 */
	public function getVersion() { 
		return $this->call('FreeImage_GetVersion');
	}

	public function getInfoHeader($dib) { 
		return $this->call('FreeImage_GetInfoHeader', array($dib));
	}

	public function getBits($dib) { 
		return $this->call('FreeImage_GetBits', array($dib));
	}

	public function allocate($width, $height, $bpp) { 
		return $this->call('FreeImage_Allocate@24', array($width, $height, $bpp, 0, 0, 0));
	}

	public function unload($bmp) { 
		return $this->call('FreeImage_Unload', array($bmp));
	}

	public function getWidth($bmp) { 
		return $this->call('FreeImage_GetWidth', array($bmp));
	}

	public function getHeight($bmp) { 
		return $this->call('FreeImage_GetHeight', array($bmp));
	}

	public function loadImage($type, $filename, $flags = 0) { 
		return $this->call('FreeImage_Load', array($type, $filename, $flags));
	}

	public function save($type, $dib, $filename, $flags = 0) { 
		return $this->call('FreeImage_Save', array($type, $dib, $filename, $flags));
	}

	public function rescale($dib, $dst_width, $dst_height, $filter = 0) { 
		return $this->call('FreeImage_Rescale', array($dib, $dst_width, $dst_height, $filter));
	}

	public function getBitInfo($dib) { 
		return array(
			'width'		=> $this->getWidth($dib),	
			'height'	=> $this->getHeight($dib),	
			'header'	=> $this->getInfoHeader($dib),	
			'bits'		=> $this->getBits($dib),	
		);
	}

	public function createImage($type, $filename, $flags = 0) { 
		$dib = $this->loadImage($type, $filename, $flags);

		$info = $this->getBitInfo($dib);		

		$image = new WBImage(array(
			'width'		=> $info['width'],
			'height'	=> $info['height'],
			'header'	=> $info['header'],
			'bits'		=> $info['bits'],
		));
		$image->create();
		$this->unload($dib);

		return $image;
	}
}


?>