/*
 * Decompiled with CFR 0.152.
 */
package com.softmeca.security.keystore;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;

public abstract class IKeyStoreHandler {
    protected abstract void initKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException;

    protected abstract void saveKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException;

    public abstract void generateKeyPair(String var1, int var2, String var3, String var4, String var5) throws NoSuchAlgorithmException, GeneralSecurityException;

    public abstract String generateCSR(String var1) throws IOException;

    public abstract Certificate getCertificate(String var1) throws KeyStoreException;

    public abstract PrivateKey getPrivateKey(String var1, String var2) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException;

    public abstract void importTrustCertificate(String var1, Certificate var2) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException;

    public abstract void importCertificate(String var1, String var2, Certificate var3) throws UnrecoverableKeyException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException;

    public abstract boolean hasAlias(String var1) throws KeyStoreException;

    public abstract ArrayList getAllEntryAlias() throws KeyStoreException;

    public abstract void deleteEntry(String var1) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException;
}

