/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.soap.DataContentHandlerFactoryImpl;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;

public class AttachmentPartImpl
extends AttachmentPart {
    MimeHeaders headers = new MimeHeaders();
    private DataHandler dataHandler;

    public int getSize() throws SOAPException {
        if (this.dataHandler == null) {
            return 0;
        }
        ByteOutputStream bout = new ByteOutputStream();
        try {
            this.dataHandler.writeTo((OutputStream)bout);
        }
        catch (IOException ex) {
            throw new SOAPException("Data handler error: " + ex);
        }
        byte[] bytes = bout.getBytes();
        if (bytes != null) {
            return bytes.length;
        }
        return -1;
    }

    public void clearContent() {
        this.dataHandler = null;
    }

    public Object getContent() throws SOAPException {
        try {
            return this.getDataHandler().getContent();
        }
        catch (IOException ex) {
            throw new SOAPException((Throwable)ex);
        }
        catch (SOAPException ex) {
            throw ex;
        }
    }

    public void setContent(Object object, String contentType) throws IllegalArgumentException {
        DataHandler dh = new DataHandler(object, contentType);
        this.setDataHandler(dh);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No data handler associated with this attachment");
        }
        return this.dataHandler;
    }

    public void setDataHandler(DataHandler dataHandler) throws IllegalArgumentException {
        if (dataHandler == null) {
            throw new IllegalArgumentException("Null dataHandler argument to setDataHandler");
        }
        this.dataHandler = dataHandler;
        this.setMimeHeader("Content-Type", dataHandler.getContentType());
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.headers.removeHeader(header);
    }

    public String[] getMimeHeader(String name) {
        return this.headers.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.headers.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.headers.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.headers.getNonMatchingHeaders(names);
    }

    boolean hasAllHeaders(MimeHeaders hdrs) {
        Iterator i = hdrs.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader hdr = (MimeHeader)i.next();
            String[] values = this.headers.getHeader(hdr.getName());
            boolean found = false;
            if (values != null) {
                int j = 0;
                while (j < values.length) {
                    if (hdr.getValue().equalsIgnoreCase(values[j])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    MimeBodyPart getMimePart() throws SOAPException {
        try {
            void ex;
            MimeBodyPart envelope = new MimeBodyPart();
            envelope.setDataHandler(this.dataHandler);
            AttachmentPartImpl.copyMimeHeaders(this.headers, envelope);
            return ex;
        }
        catch (Exception ex) {
            throw new SOAPException("Unable to externalize attachment", (Throwable)ex);
        }
    }

    public static void copyMimeHeaders(MimeHeaders headers, MimeBodyPart mbp) throws SOAPException {
        Iterator i = headers.getAllHeaders();
        while (i.hasNext()) {
            try {
                MimeHeader mh = (MimeHeader)i.next();
                mbp.addHeader(mh.getName(), mh.getValue());
            }
            catch (Exception ex) {
                throw new SOAPException("Unable to copy MIME header", (Throwable)ex);
            }
        }
    }

    public static void copyMimeHeaders(MimeBodyPart mbp, AttachmentPartImpl ap) throws SOAPException {
        try {
            Enumeration e = mbp.getNonMatchingHeaders(new String[]{"Content-Type"});
            while (e.hasMoreElements()) {
                Header hdr = (Header)e.nextElement();
                ap.addMimeHeader(hdr.getName(), hdr.getValue());
            }
        }
        catch (Exception ex) {
            throw new SOAPException("Unable to copy MIME headers into attachment", (Throwable)ex);
        }
    }

    static {
        DataHandler.setDataContentHandlerFactory((DataContentHandlerFactory)new DataContentHandlerFactoryImpl());
    }
}

