/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;

public class JpegDataContentHandler
extends Component
implements DataContentHandler {
    public final String STR_SRC = "java.awt.image";

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[1];
        try {
            flavors[0] = new ActivationDataFlavor(Class.forName("java.awt.image"), "image/jpeg", "JPEG");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return flavors;
    }

    public Object getTransferData(DataFlavor df, DataSource ds) {
        if (df.getMimeType().startsWith("image/jpeg") && df.getRepresentationClass().getName().equals("java.awt.image")) {
            InputStream inputStream = null;
            JPEGImageDecoder decoder = null;
            BufferedImage jpegLoadImage = null;
            try {
                inputStream = ds.getInputStream();
                decoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
                jpegLoadImage = decoder.decodeAsBufferedImage();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return jpegLoadImage;
        }
        return null;
    }

    public Object getContent(DataSource ds) {
        InputStream inputStream = null;
        JPEGImageDecoder decoder = null;
        BufferedImage jpegLoadImage = null;
        try {
            inputStream = ds.getInputStream();
            decoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
            jpegLoadImage = decoder.decodeAsBufferedImage();
        }
        catch (Exception e) {
            // empty catch block
        }
        return jpegLoadImage;
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (!mimeType.equals("image/jpeg")) {
            throw new IOException("Invalid content type \"" + mimeType + "\" for ImageContentHandler");
        }
        if (obj.equals(null)) {
            throw new IOException("Null object for ImageContentHandler");
        }
        try {
            BufferedImage bufImage = null;
            if (obj instanceof BufferedImage) {
                bufImage = (BufferedImage)obj;
            } else {
                Image img = (Image)obj;
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(img, 0);
                tracker.waitForAll();
                bufImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
                Graphics2D g = bufImage.createGraphics();
                g.drawImage(img, 0, 0, null);
            }
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)os);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bufImage);
            param.setQuality(1.0f, false);
            encoder.encode(bufImage, param);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Unable to run the JPEG Encoder on a stream " + ex.getMessage());
        }
    }
}

