/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.application;

import java.util.Hashtable;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.application.BlockingApplicationProcesser;
import org.kldp.ebmsh.application.EbmsApplicationProcesserException;
import org.kldp.ebmsh.message.packaging.EbmsEbxmlMessageException;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.util.MessageBuilderUtil;
import org.kldp.ebmsh.queue.ApplicationResultMessage;
import org.kldp.util.log.LogUtil;

public class BlockingApplicationProcesserManager {
    private static final Log log = LogFactory.getLog(BlockingApplicationProcesserManager.class);
    private static final BlockingApplicationProcesserManager instance = new BlockingApplicationProcesserManager();
    private Hashtable applicationProcessers = new Hashtable();

    private BlockingApplicationProcesserManager() {
    }

    public static BlockingApplicationProcesserManager getInstance() {
        return instance;
    }

    public void registerBlockingApplicationProcesser(long _uid, BlockingApplicationProcesser _applicationProcesser) throws EbmsApplicationProcesserException {
        this.applicationProcessers.put(new Long(_uid), _applicationProcesser);
    }

    public void removeBlockingApplicationProcesser(long _uid) throws EbmsApplicationProcesserException {
        this.applicationProcessers.remove(new Long(_uid));
    }

    public void onMessage(ApplicationResultMessage applicationResultMessage) throws EbmsApplicationProcesserException {
        try {
            EbxmlMessage responseEbxmlMessage = null;
            long uid = applicationResultMessage.getUid();
            if (!this.applicationProcessers.containsKey(new Long(uid))) {
                log.fatal((Object)("\uc751\ub2f5\uc744 \uae30\ub2e4\ub9ac\uc9c0 \uc54a\ub294 \uba54\uc2dc\uc9c0\uac00 \ub3c4\ucc29\ud588\uc2b5\ub2c8\ub2e4. UID -> " + uid));
                return;
            }
            BlockingApplicationProcesser applicationProcesser = (BlockingApplicationProcesser)this.applicationProcessers.get(new Long(uid));
            this.removeBlockingApplicationProcesser(uid);
            try {
                if (applicationResultMessage.getPayloadCount() == 0) {
                    responseEbxmlMessage = MessageBuilderUtil.buildCustomActionMessage(applicationResultMessage.getFrom(), applicationResultMessage.getTo(), applicationResultMessage.getCpaId(), applicationResultMessage.getConversationId(), applicationResultMessage.getAction(), applicationResultMessage.getService());
                    String refToMessageId = applicationResultMessage.getRefToMessageId();
                    responseEbxmlMessage.getEbxmlHeader().getMessageHeader().getMessageData().addRefToMessageId().setValue(refToMessageId);
                    responseEbxmlMessage.saveChanges();
                } else {
                    responseEbxmlMessage = MessageBuilderUtil.buildCustomActionMessageWithPayloads(applicationResultMessage.getFrom(), applicationResultMessage.getTo(), applicationResultMessage.getCpaId(), applicationResultMessage.getConversationId(), applicationResultMessage.getAction(), applicationResultMessage.getService(), applicationResultMessage.getPayloads());
                    String refToMessageId = applicationResultMessage.getRefToMessageId();
                    responseEbxmlMessage.getEbxmlHeader().getMessageHeader().getMessageData().addRefToMessageId().setValue(refToMessageId);
                    responseEbxmlMessage.saveChanges();
                }
            }
            catch (EbmsEbxmlMessageException e) {
                log.fatal((Object)("\uc751\ub2f5\uc73c\ub85c \ubcf4\ub0bc EbxmlMessage\ub97c \uc0dd\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\n" + LogUtil.stackTraceToString((Throwable)e)));
                responseEbxmlMessage = null;
            }
            applicationProcesser.processNotify(responseEbxmlMessage);
        }
        catch (SOAPException e) {
            throw new EbmsApplicationProcesserException(1, 0, e);
        }
    }
}

