/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.kldp.ebmsh.config.EbmsConfigException;

public class EbmsProperties {
    private Properties bizboxProperties;
    private final String applicationResultQueueName = "EbmsApplicationResultQueue";
    private final String trackerQueueName = "EbmsTrackerQueue";
    private final String cpaManagerJNDIName = "CpaManager";
    private final String cpaPath = "cpa";
    private final String messagePath = "message";
    private final String keyStoreType = "jks";
    private final String keyStorePath = "jks";
    private final String keyStorePassword = "softmeca!!";
    private final String keyPassword = "softmeca!!";
    private final String csrPath = "csr";

    public EbmsProperties() {
        this.bizboxProperties = new Properties();
    }

    public EbmsProperties(Properties bizboxProperties) {
        this.bizboxProperties = bizboxProperties;
    }

    public void saveToFile(String filePath) {
        try {
            FileOutputStream os = new FileOutputStream(new File(filePath));
            this.bizboxProperties.store(os, "Bizbox config file");
        }
        catch (IOException e) {
            throw new EbmsConfigException(1, 0, e);
        }
    }

    public String getApplicationResultQueueName() {
        return "EbmsApplicationResultQueue";
    }

    public String getBizboxDatabaseHeaderName() {
        return this.bizboxProperties.getProperty("bizboxDatabaseHeaderName");
    }

    public void setBizboxDatabaseHeaderName(String bizboxDatabaseHeaderName) {
        this.bizboxProperties.setProperty("bizboxDatabaseHeaderName", bizboxDatabaseHeaderName);
    }

    public String getConnectionTimeOut() {
        return this.bizboxProperties.getProperty("connectionTimeOut");
    }

    public void setConnectionTimeOut(String connectionTimeOut) {
        this.bizboxProperties.setProperty("connectionTimeOut", connectionTimeOut);
    }

    public String getCpaManagerJNDIName() {
        return "CpaManager";
    }

    public String getCpaPath() {
        return "cpa";
    }

    public String getCsrPath() {
        return "csr";
    }

    public String getDatabaseType() {
        return this.bizboxProperties.getProperty("databaseType");
    }

    public void setDatabaseType(String databaseType) {
        this.bizboxProperties.setProperty("databaseType", databaseType);
    }

    public String getDataSourceName() {
        return this.bizboxProperties.getProperty("dataSourceName");
    }

    public void setDataSourceName(String dataSourceName) {
        this.bizboxProperties.setProperty("dataSourceName", dataSourceName);
    }

    public String getKeyPassword() {
        return "softmeca!!";
    }

    public String getKeyStorePassword() {
        return "softmeca!!";
    }

    public String getKeyStorePath() {
        return "jks";
    }

    public String getKeyStoreType() {
        return "jks";
    }

    public String getMessagePath() {
        return "message";
    }

    public String getPkcs11cfgPath() {
        return this.bizboxProperties.getProperty("pkcs11cfgPath");
    }

    public void setPkcs11cfgPath(String pkcs11cfgPath) {
        this.bizboxProperties.setProperty("pkcs11cfgPath", pkcs11cfgPath);
    }

    public String getQueueConnectionFactoryName() {
        return this.bizboxProperties.getProperty("queueConnectionFactoryName");
    }

    public void setQueueConnectionFactoryName(String queueConnectionFactoryName) {
        this.bizboxProperties.setProperty("queueConnectionFactoryName", queueConnectionFactoryName);
    }

    public String getQueueJNDIHeaderName() {
        return this.bizboxProperties.getProperty("queueJNDIHeaderName");
    }

    public void setQueueJNDIHeaderName(String queueJNDIHeaderName) {
        this.bizboxProperties.setProperty("queueJNDIHeaderName", queueJNDIHeaderName);
    }

    public String getTrackerQueueName() {
        return "EbmsTrackerQueue";
    }
}

