/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.cpa;

import java.io.File;
import java.math.BigInteger;
import java.util.Calendar;
import org.apache.xmlbeans.XmlObject;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.cpa.EbmsCpaException;
import org.kldp.ebmsh.cpa.PartyInfo;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.CollaborationProtocolAgreementDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.ConstituentDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.NamespaceSupportedDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.PackagingDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.PartyInfoDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.SimplePartDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.StatusDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.StatusValueType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Cpa {
    private CollaborationProtocolAgreementDocument cpaDoc = null;
    private CollaborationProtocolAgreementDocument.CollaborationProtocolAgreement cpa = null;

    public Cpa() {
        this.cpaDoc = CollaborationProtocolAgreementDocument.Factory.newInstance();
        this.cpa = this.cpaDoc.addNewCollaborationProtocolAgreement();
    }

    public Cpa(CollaborationProtocolAgreementDocument cpaDoc, CollaborationProtocolAgreementDocument.CollaborationProtocolAgreement cpa) {
        this.cpaDoc = cpaDoc;
        this.cpa = cpa;
    }

    public void save() throws EbmsCpaException {
        try {
            this.cpaDoc.save(new File(String.valueOf(EbmsConstants.cpaPath) + this.getCpaId() + ".xml"));
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public void setValue(String pathExpression, String newValue) throws EbmsCpaException {
        try {
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String dsNamespace = "declare namespace ds='http://www.w3.org/2000/09/xmldsig#';";
            String xlinkNamespace = "declare namespace xlink='http://www.w3.org/1999/xlink';";
            XmlObject[] xmlObject = this.cpa.selectPath(String.valueOf(tpNamespace) + dsNamespace + xlinkNamespace + pathExpression);
            xmlObject[0].getDomNode().setNodeValue(newValue);
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public String getValue(String pathExpression) throws EbmsCpaException {
        try {
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String dsNamespace = "declare namespace ds='http://www.w3.org/2000/09/xmldsig#';";
            String xlinkNamespace = "declare namespace xlink='http://www.w3.org/1999/xlink';";
            XmlObject[] xmlObject = this.cpa.selectPath(String.valueOf(tpNamespace) + dsNamespace + xlinkNamespace + pathExpression);
            return xmlObject[0].getDomNode().getNodeValue();
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public String getCpaToString() throws EbmsCpaException {
        try {
            return this.cpaDoc.toString();
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public String getCpaId() throws EbmsCpaException {
        try {
            return this.cpa.getCpaid();
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public StatusDocument.Status addStatus(StatusValueType.Enum _status) throws EbmsCpaException {
        try {
            StatusDocument.Status status = this.cpa.addNewStatus();
            status.setValue(_status);
            return status;
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public void setStatus(StatusValueType.Enum _status) throws EbmsCpaException {
        try {
            this.cpa.getStatus().setValue(_status);
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public StatusValueType.Enum getStatus() throws EbmsCpaException {
        try {
            return this.cpa.getStatus().getValue();
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public Calendar addStart(Calendar _start) throws EbmsCpaException {
        try {
            this.cpa.setStart(_start);
            return this.cpa.getStart();
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public void setStart(Calendar start) throws EbmsCpaException {
        try {
            this.cpa.setStart(start);
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public Calendar getStart() throws EbmsCpaException {
        try {
            return this.cpa.getStart();
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public Calendar addEnd(Calendar _end) throws EbmsCpaException {
        try {
            this.cpa.setEnd(_end);
            return this.cpa.getEnd();
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public void setEnd(Calendar end) throws EbmsCpaException {
        try {
            this.cpa.setEnd(end);
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public Calendar getEnd() throws EbmsCpaException {
        try {
            return this.cpa.getEnd();
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public PartyInfo addPartyInfo(String _partyName, String _defaultMshChannelId, String _defaultMshPackageId) throws EbmsCpaException {
        try {
            PartyInfoDocument.PartyInfo partyInfo = this.cpa.addNewPartyInfo();
            partyInfo.setPartyName(_partyName);
            partyInfo.setDefaultMshChannelId(_defaultMshChannelId);
            partyInfo.setDefaultMshPackageId(_defaultMshPackageId);
            PartyInfo _partyInfo = new PartyInfo(partyInfo);
            return _partyInfo;
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public void setPartyInfo(String _oldPartyName, String _newPartyName, String _defaultMshChannelId, String _defaultMshPackageId) throws EbmsCpaException {
        try {
            PartyInfoDocument.PartyInfo[] partyInfos = this.cpa.getPartyInfoArray();
            int i = 0;
            while (i < partyInfos.length) {
                if (partyInfos[i].getPartyName().equals(_oldPartyName)) {
                    if (_newPartyName != null) {
                        partyInfos[i].setPartyName(_newPartyName);
                    }
                    if (_defaultMshChannelId != null) {
                        partyInfos[i].setDefaultMshChannelId(_defaultMshChannelId);
                    }
                    if (_defaultMshPackageId != null) {
                        partyInfos[i].setDefaultMshPackageId(_defaultMshPackageId);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public PartyInfo[] getPartyInfos() throws EbmsCpaException {
        try {
            PartyInfo[] partyInfoArray = null;
            PartyInfoDocument.PartyInfo[] partyInfo = this.cpa.getPartyInfoArray();
            if (partyInfo != null) {
                partyInfoArray = new PartyInfo[partyInfo.length];
                int i = 0;
                while (i < partyInfoArray.length) {
                    partyInfoArray[i] = new PartyInfo(partyInfo[i]);
                    ++i;
                }
            }
            return partyInfoArray;
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public PartyInfo getPartyInfo(String _partyName) throws EbmsCpaException {
        try {
            PartyInfo partyInfo = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "$this/tp:PartyInfo[@tp:partyName='" + _partyName + "']";
            XmlObject[] results = this.cpa.selectPath(String.valueOf(tpNamespace) + pathExpression);
            if (results.length != 0) {
                partyInfo = new PartyInfo((PartyInfoDocument.PartyInfo)results[0]);
            }
            return partyInfo;
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public SimplePartDocument.SimplePart addSimplePart(String _id, String _mimetype, String _nameSpace) throws EbmsCpaException {
        try {
            SimplePartDocument.SimplePart simplePart = this.cpa.addNewSimplePart();
            simplePart.setId(_id);
            simplePart.setMimetype(_mimetype);
            if (_nameSpace != null) {
                NamespaceSupportedDocument.NamespaceSupported nameSpaceSupported = simplePart.addNewNamespaceSupported();
                nameSpaceSupported.setLocation("http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
                nameSpaceSupported.setVersion("2.0");
                nameSpaceSupported.setStringValue(_nameSpace);
            }
            return simplePart;
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public void setSimplePart(String _oldId, String _newId, String _mimeType, String _nameSpace) throws EbmsCpaException {
        try {
            SimplePartDocument.SimplePart[] simplePart = this.cpa.getSimplePartArray();
            int i = 0;
            while (i < simplePart.length) {
                if (simplePart[i].getId().equals(_oldId)) {
                    if (_newId != null) {
                        this.setAttribute(_oldId, _newId);
                    }
                    if (_mimeType != null) {
                        simplePart[i].setMimetype(_mimeType);
                    }
                    if (_nameSpace != null) {
                        NamespaceSupportedDocument.NamespaceSupported namespaceSupported = simplePart[i].getNamespaceSupportedArray(0);
                        namespaceSupported.setStringValue(_nameSpace);
                    }
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public String[] getSimplePartIds() throws EbmsCpaException {
        try {
            String[] simplePartId = null;
            SimplePartDocument.SimplePart[] simplePartArray = null;
            simplePartArray = this.cpa.getSimplePartArray();
            if (simplePartArray != null) {
                simplePartId = new String[simplePartArray.length];
                int i = 0;
                while (i < simplePartArray.length) {
                    simplePartId[i] = simplePartArray[i].getId();
                    ++i;
                }
            }
            return simplePartId;
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public PackagingDocument.Packaging addPackagingwithEncapsulation(String _packagingId, String _encapsulationId, String _constituentMessageHeaderIdRef, String _constituentPayloadIdRef) throws EbmsCpaException {
        try {
            PackagingDocument.Packaging packaging = this.cpa.addNewPackaging();
            packaging.setId(_packagingId);
            PackagingDocument.Packaging.ProcessingCapabilities processingCapabilities = packaging.addNewProcessingCapabilities();
            processingCapabilities.setGenerate(true);
            processingCapabilities.setParse(true);
            PackagingDocument.Packaging.CompositeList compositeList = packaging.addNewCompositeList();
            PackagingDocument.Packaging.CompositeList.Encapsulation encapsulation = compositeList.addNewEncapsulation();
            encapsulation.setId(_encapsulationId);
            encapsulation.setMimetype("multipart/related");
            encapsulation.setMimeparameters("type=&quot;text/xml&quot;");
            ConstituentDocument.Constituent constituentMessageHeader = encapsulation.addNewConstituent();
            constituentMessageHeader.setIdref(_constituentMessageHeaderIdRef);
            ConstituentDocument.Constituent constituentPayload = encapsulation.addNewConstituent();
            constituentPayload.setIdref(_constituentPayloadIdRef);
            constituentPayload.setMinOccurs(new BigInteger("0"));
            constituentPayload.setMaxOccurs(new BigInteger("99"));
            return packaging;
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public PackagingDocument.Packaging addPackagingwithComposite(String _packagingId, String _compositeId, String _constituentMessageHeaderIdRef, String _constituentPayloadIdRef) throws EbmsCpaException {
        try {
            PackagingDocument.Packaging packaging = this.cpa.addNewPackaging();
            packaging.setId(_packagingId);
            PackagingDocument.Packaging.ProcessingCapabilities processingCapabilities = packaging.addNewProcessingCapabilities();
            processingCapabilities.setGenerate(true);
            processingCapabilities.setParse(true);
            PackagingDocument.Packaging.CompositeList compositeList = packaging.addNewCompositeList();
            PackagingDocument.Packaging.CompositeList.Composite composite = compositeList.addNewComposite();
            composite.setId(_compositeId);
            composite.setMimetype("multipart/related");
            composite.setMimeparameters("type=&quot;text/xml&quot;");
            ConstituentDocument.Constituent constituentMessageHeader = composite.addNewConstituent();
            constituentMessageHeader.setIdref(_constituentMessageHeaderIdRef);
            ConstituentDocument.Constituent constituentPayload = composite.addNewConstituent();
            constituentPayload.setIdref(_constituentPayloadIdRef);
            constituentPayload.setMinOccurs(new BigInteger("0"));
            constituentPayload.setMaxOccurs(new BigInteger("99"));
            return packaging;
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public void setPackaging(String _oldPackagingId, String _newPackagingId) throws EbmsCpaException {
        try {
            PackagingDocument.Packaging[] packagings = this.cpa.getPackagingArray();
            int i = 0;
            while (i < packagings.length) {
                if (packagings[i].getId().equals(_oldPackagingId)) {
                    this.setAttribute(_oldPackagingId, _newPackagingId);
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public void setCompositeUnderPackaging(String _packagingId, String _oldCompositeId, String _newCompositeId, String _messageHeaderIdRef, String _payLoadIdRef) throws EbmsCpaException {
        try {
            PackagingDocument.Packaging[] packagings = this.cpa.getPackagingArray();
            int i = 0;
            while (i < packagings.length) {
                if (packagings[i].getId().equals(_packagingId)) {
                    if (_newCompositeId != null) {
                        this.setAttribute(_oldCompositeId, _newCompositeId);
                    }
                    if (_messageHeaderIdRef != null) {
                        packagings[i].getCompositeListArray(0).getCompositeArray(0).getConstituentArray(0).setIdref(_packagingId);
                    }
                    if (_payLoadIdRef != null) {
                        packagings[i].getCompositeListArray(0).getCompositeArray(1).getConstituentArray(1).setIdref(_payLoadIdRef);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public void setEncapsulationUnderPackaging(String _packagingId, String _oldEncapsulationId, String _newEncapsulationId, String _messageHeaderIdRef, String _payLoadIdRef) throws EbmsCpaException {
        try {
            PackagingDocument.Packaging[] packagings = this.cpa.getPackagingArray();
            int i = 0;
            while (i < packagings.length) {
                if (packagings[i].getId().equals(_packagingId)) {
                    if (_newEncapsulationId != null) {
                        this.setAttribute(_oldEncapsulationId, _newEncapsulationId);
                    }
                    if (_messageHeaderIdRef != "") {
                        packagings[i].getCompositeListArray(0).getEncapsulationArray(0).getConstituent().setIdref(_messageHeaderIdRef);
                    }
                    if (_payLoadIdRef != "") {
                        packagings[i].getCompositeListArray(0).getEncapsulationArray(1).getConstituent().setIdref(_payLoadIdRef);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    public String[] getPackagingIds() throws EbmsCpaException {
        try {
            String[] packgingId = null;
            PackagingDocument.Packaging[] packging = this.cpa.getPackagingArray();
            if (packging != null) {
                packgingId = new String[packging.length];
                int i = 0;
                while (i < packging.length) {
                    packgingId[i] = packging[i].getId();
                    ++i;
                }
            }
            return packgingId;
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }

    protected void setAttribute(String _oldValue, String _newValue) throws EbmsCpaException {
        try {
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "//*[@*='" + _oldValue + "']";
            XmlObject[] results = this.cpaDoc.selectPath(String.valueOf(tpNamespace) + pathExpression);
            int i = 0;
            while (i < results.length) {
                Node node = results[i].getDomNode();
                NamedNodeMap nnm = node.getAttributes();
                int j = 0;
                while (j < nnm.getLength()) {
                    Node _node = nnm.item(j);
                    if (_node.getNodeValue().equals(_oldValue)) {
                        _node.setNodeValue(_newValue);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw new EbmsCpaException(0, 0, t);
        }
    }
}

