/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.packaging.impl;

import com.sun.xml.messaging.saaj.soap.dom4j.TextImpl;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.Text;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.message.packaging.EbxmlElement;

public class EbxmlElementImpl
implements EbxmlElement {
    protected SOAPEnvelope env = null;
    private static Log log = LogFactory.getLog(EbxmlElementImpl.class);
    protected SOAPElement soapElement;

    public EbxmlElementImpl() {
    }

    public EbxmlElementImpl(SOAPEnvelope env, SOAPElement soapElement) throws SOAPException {
        this.env = env;
        this.soapElement = soapElement;
    }

    public void setValue(String value) throws SOAPException {
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Text text = (Text)it.next();
            text.detachNode();
        }
        if (this.soapElement == null) {
            log.info((Object)"soap Element is null");
        }
        this.soapElement.addTextNode(value);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        return this.soapElement.addChildElement(name);
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        return this.soapElement.addChildElement(localName);
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        return this.soapElement.addChildElement(localName, prefix);
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        return this.soapElement.addChildElement(localName, prefix, uri);
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        return this.soapElement.addChildElement(element);
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        return this.soapElement.addTextNode(text);
    }

    public SOAPElement addAttribute(Name name, String arg1) throws SOAPException {
        return this.soapElement.addAttribute(name, arg1);
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        return this.soapElement.addNamespaceDeclaration(prefix, uri);
    }

    public String getAttributeValue(Name name) {
        return this.soapElement.getAttributeValue(name);
    }

    public Iterator getAllAttributes() {
        return this.soapElement.getAllAttributes();
    }

    public String getNamespaceURI(String arg0) {
        return this.soapElement.getNamespaceURI(arg0);
    }

    public Iterator getNamespacePrefixes() {
        return this.soapElement.getNamespacePrefixes();
    }

    public Name getElementName() {
        return this.soapElement.getElementName();
    }

    public boolean removeAttribute(Name name) {
        return this.soapElement.removeAttribute(name);
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        return this.soapElement.removeNamespaceDeclaration(prefix);
    }

    public Iterator getChildElements() {
        if (this.soapElement == null) {
            log.info((Object)"soapElement is null");
        }
        return this.soapElement.getChildElements();
    }

    public Iterator getChildElements(Name name) {
        return this.soapElement.getChildElements(name);
    }

    public Iterator getChildElements(String localName) throws SOAPException {
        Name name = this.env.createName(localName, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        Iterator i = this.getChildElements(name);
        return i;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        this.soapElement.setEncodingStyle(encodingStyle);
    }

    public String getEncodingStyle() {
        return this.soapElement.getEncodingStyle();
    }

    public String getValue() {
        return this.soapElement.getValue();
    }

    public void setParentElement(SOAPElement element) throws SOAPException {
        this.soapElement.setParentElement(element);
    }

    public SOAPElement getParentElement() {
        return this.soapElement.getParentElement();
    }

    public void detachNode() {
        this.soapElement.detachNode();
    }

    public void recycleNode() {
        this.soapElement.recycleNode();
    }

    public SOAPElement addEbxmlChildElement(String localName) throws SOAPException {
        return this.addChildElement(localName, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
    }

    public SOAPElement addUniqueEbxmlChildElement(String localName) throws SOAPException {
        this.checkDuplicateElement(localName);
        return this.addChildElement(localName, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
    }

    public void checkDuplicateElement(String localName) throws SOAPException {
        if (this.hasElement(localName)) {
            throw new SOAPException("Element already Exists. \uc774\ubbf8 \uc5d8\ub9ac\uba3c\ud2b8\uac00 \uc874\uc7ac\ud569\ub2c8\ub2e4." + localName);
        }
    }

    public boolean hasElement(String localName) throws SOAPException {
        Iterator i = this.getChildElements();
        SOAPElement element = null;
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof TextImpl) {
                TextImpl textImpl = (TextImpl)o;
            }
            if (!(o instanceof SOAPElement) || !(element = (SOAPElement)o).getElementName().getLocalName().equals(localName)) continue;
            return true;
        }
        return false;
    }

    public void setEbxmlAttribute(Name name, String value) throws SOAPException {
        this.removeAttribute(name);
        this.addAttribute(name, value);
    }

    public void setEbxmlAttribute(String localName, String value) throws SOAPException {
        Name name = this.env.createName(localName, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        this.setEbxmlAttribute(name, value);
    }

    public void setSoapAttribute(String localName, String value) throws SOAPException {
        Name name = this.env.createName(localName, "soap-env", "http://schemas.xmlsoap.org/soap/envelope/");
        this.setEbxmlAttribute(name, value);
    }

    public String getEbxmlAttribute(String localName) throws SOAPException {
        Name name = this.env.createName(localName, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        return this.getAttributeValue(name);
    }

    public SOAPElement getFirstChildElement(String localName) throws SOAPException {
        Name name = this.env.createName(localName, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        Iterator i = this.getChildElements(name);
        SOAPElement soap = null;
        if (i != null && i.hasNext()) {
            soap = (SOAPElement)i.next();
        }
        return soap;
    }
}

