/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.packaging.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.message.packaging.EbxmlBody;
import org.kldp.ebmsh.message.packaging.EbxmlElement;
import org.kldp.ebmsh.message.packaging.EbxmlHeader;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.EbxmlMessageFactory;
import org.kldp.ebmsh.message.packaging.Manifest;
import org.kldp.ebmsh.message.packaging.MessageData;
import org.kldp.ebmsh.message.packaging.MessageHeader;
import org.kldp.ebmsh.message.packaging.PartyId;
import org.kldp.ebmsh.message.packaging.Reference;
import org.kldp.ebmsh.message.packaging.Schema;
import org.kldp.ebmsh.message.packaging.impl.EbxmlBodyImpl;
import org.kldp.ebmsh.message.packaging.impl.EbxmlHeaderImpl;
import org.kldp.ebmsh.message.packaging.impl.PartyIdImpl;
import org.kldp.ebmsh.message.security.SecurityUtils;
import org.kldp.util.log.LogUtil;

public class EbxmlMessageImpl
extends EbxmlMessage {
    private static Log log = LogFactory.getLog(EbxmlMessageImpl.class);
    private EbxmlMessageFactory messageFactory = null;
    private SOAPMessage message = null;

    public EbxmlMessageImpl() {
    }

    public EbxmlMessageImpl(SOAPMessage message, EbxmlMessageFactory factory) throws SOAPException {
        this.message = message;
        this.messageFactory = factory;
    }

    public String getContentDescription() {
        return null;
    }

    public void setContentDescription(String arg0) {
    }

    public SOAPPart getSOAPPart() {
        return this.message.getSOAPPart();
    }

    public void removeAllAttachments() {
        this.message.removeAllAttachments();
    }

    public int countAttachments() {
        return this.message.countAttachments();
    }

    public Iterator getAttachments() {
        return this.message.getAttachments();
    }

    public Iterator getAttachments(MimeHeaders arg0) {
        return this.message.getAttachments(arg0);
    }

    public void addAttachmentPart(AttachmentPart arg0) {
        this.message.addAttachmentPart(arg0);
    }

    public void addPayload(DataHandler dh, String contentid) {
        AttachmentPart attachment = this.message.createAttachmentPart(dh);
        String cid4mime = "<" + contentid + ">";
        attachment.setContentId(cid4mime);
        attachment.setContentType("text/xml");
        try {
            EbxmlBody eb = this.getEbxmlBody();
            Manifest mf = null;
            mf = !eb.hasManifest() ? eb.addManifest() : eb.getManifest();
            Reference rf = mf.addReference();
            rf.setXlinkRef("cid:" + contentid);
            this.addAttachmentPart(attachment);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void addPayload(DataHandler dh, String contentid, String role) {
        AttachmentPart attachment = this.message.createAttachmentPart(dh);
        String cid4mime = "<" + contentid + ">";
        attachment.setContentId(cid4mime);
        attachment.setContentType("text/xml");
        try {
            EbxmlBody eb = this.getEbxmlBody();
            Manifest mf = null;
            mf = !eb.hasManifest() ? eb.addManifest() : eb.getManifest();
            Reference rf = mf.addReference();
            rf.setXlinkRef("cid:" + contentid);
            rf.setXlinkRole(role);
            this.addAttachmentPart(attachment);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void addPayload(DataHandler dh, String contentid, String role, String schema) {
        AttachmentPart attachment = this.message.createAttachmentPart(dh);
        String cid4mime = "<" + contentid + ">";
        attachment.setContentId(cid4mime);
        attachment.setContentType("text/xml");
        try {
            EbxmlBody eb = this.getEbxmlBody();
            Manifest mf = null;
            mf = !eb.hasManifest() ? eb.addManifest() : eb.getManifest();
            Reference rf = mf.addReference();
            rf.setXlinkRef("cid:" + contentid);
            rf.setXlinkRole(role);
            Schema sm = rf.addSchema();
            sm.setSchemaLocation(schema);
            this.addAttachmentPart(attachment);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public DataHandler getPayload(String contentId) {
        DataHandler dh = null;
        Iterator itManifest = this.getAttachments();
        while (itManifest.hasNext()) {
            try {
                AttachmentPart apart = (AttachmentPart)itManifest.next();
                String cid = apart.getContentId();
                if (cid.startsWith("<")) {
                    cid = cid.substring(1, cid.length() - 1);
                }
                if (!cid.equals(contentId)) continue;
                log.info((Object)("compare " + cid + " == " + contentId));
                dh = apart.getDataHandler();
            }
            catch (Exception e) {
                log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            }
        }
        return dh;
    }

    public DataHandler getPayload(int index) {
        int i_index = 0;
        DataHandler dh = null;
        Iterator itManifest = this.getAttachments();
        while (itManifest.hasNext()) {
            ++i_index;
            try {
                AttachmentPart apart = (AttachmentPart)itManifest.next();
                String cid = apart.getContentId();
                if (cid.startsWith("<")) {
                    cid = cid.substring(1, cid.length() - 1);
                }
                if (index != i_index) continue;
                dh = apart.getDataHandler();
            }
            catch (Exception e) {
                log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            }
        }
        return dh;
    }

    public String getPayloadAsString(int index) {
        int i_index = 0;
        String payload = null;
        Iterator itManifest = this.getAttachments();
        while (itManifest.hasNext()) {
            ++i_index;
            try {
                AttachmentPart apart = (AttachmentPart)itManifest.next();
                String cid = apart.getContentId();
                if (cid.startsWith("<")) {
                    cid = cid.substring(1, cid.length() - 1);
                }
                if (index != i_index) continue;
                DataHandler dh = apart.getDataHandler();
                Object o = dh.getContent();
                log.info((Object)("\ucca8\ubd80 \ubb38\uc11c\uc758 type \uc740 " + dh.getContentType() + " \uc785\ub2c8\ub2e4 "));
                if (dh.getContentType().equals("text/xml") && o instanceof String) {
                    payload = (String)o;
                    log.info((Object)"xml \ud615\ud0dc\uc758 \ucca8\ubd80\ubb38\uc11c\ub97c \uac00\uc9c0\uace0 \uc635\ub2c8\ub2e4.");
                    continue;
                }
                log.info((Object)"\ubb38\uc11c\uc758 \ud615\ud0dc\uac00 xml\uc774 \uc544\ub2c8\uc5b4\uc11c \uac00\uc838\uc62c\uc218 \uc5c6\uc2b5\ub2c8\ub2e4. ");
            }
            catch (Exception e) {
                log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            }
        }
        return payload;
    }

    public void addPayloadforKorBit(DataHandler dh, String contentid) {
        AttachmentPart attachment = this.message.createAttachmentPart(dh);
        attachment.setContentId(contentid);
        this.addAttachmentPart(attachment);
    }

    public AttachmentPart createAttachmentPart() {
        return this.message.createAttachmentPart();
    }

    public MimeHeaders getMimeHeaders() {
        return this.message.getMimeHeaders();
    }

    public void saveChanges() throws SOAPException {
        this.message.saveChanges();
    }

    public boolean saveRequired() {
        return this.message.saveRequired();
    }

    public void writeTo(OutputStream arg0) throws SOAPException, IOException {
        this.message.writeTo(arg0);
    }

    public String toString() {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            this.writeTo(bo);
            bo.flush();
            return new String(bo.toByteArray());
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            return null;
        }
    }

    public EbxmlMessageFactory getMessageFactory() throws SOAPException {
        return this.messageFactory;
    }

    public EbxmlHeader getEbxmlHeader() throws SOAPException {
        SOAPPart sp = this.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPHeader sh = envelope.getHeader();
        EbxmlHeaderImpl eh = new EbxmlHeaderImpl(envelope, sh);
        return eh;
    }

    public EbxmlBody getEbxmlBody() throws SOAPException {
        SOAPPart sp = this.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPBody sb = envelope.getBody();
        EbxmlBodyImpl eb = new EbxmlBodyImpl(envelope, sb);
        return eb;
    }

    public String getMessageId() {
        String msgId = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            msgId = mh.getMessageData().getMessagId().getValue();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return msgId;
    }

    public String getTimestamp() {
        String timestamp = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            timestamp = mh.getMessageData().getTimestamp().getValue();
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return timestamp;
    }

    public String getTimeToLive() {
        String timeToLive = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            timeToLive = mh.getMessageData().getTimeToLive().getValue();
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return timeToLive;
    }

    public String getCPAId() {
        String cpaId = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            cpaId = mh.getCPAId().getValue();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return cpaId;
    }

    public String getFrom() {
        String from = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            Iterator partyids = mh.getFrom().getPartyIds();
            PartyIdImpl pid = (PartyIdImpl)partyids.next();
            from = pid.getValue();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return from;
    }

    public String getTo() {
        String to = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            Iterator partyids = mh.getTo().getPartyIds();
            PartyIdImpl pid = (PartyIdImpl)partyids.next();
            to = pid.getValue();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return to;
    }

    public String getConversationId() {
        String convId = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            convId = mh.getConversationId().getValue();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return convId;
    }

    public String getService() {
        String service = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            service = mh.getService().getValue();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return service;
    }

    public String getAction() {
        String action = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            action = mh.getAction().getValue();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return action;
    }

    public String getRefToMessageId() {
        String refToMessageId = null;
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.getMessageHeader();
            refToMessageId = mh.getMessageData().getRefToMessageId().getValue();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return refToMessageId;
    }

    public void setMessageId(String messageId) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            MessageData md = mh.getMessageData();
            md.getMessagId().setValue(messageId);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setTimestamp(String timestamp) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            MessageData md = mh.getMessageData();
            md.getTimestamp().setValue(timestamp);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setConversationId(String conversationId) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            mh.getConversationId().setValue(conversationId);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setCPAId(String cpaId) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            mh.getCPAId().setValue(cpaId);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setFrom(String from) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            ((EbxmlElement)mh.getFrom().getPartyIds().next()).setValue(from);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setFrom(String partyId, String type) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            PartyId pid = mh.getFrom().addPartyId();
            pid.setType(type);
            pid.setValue(partyId);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setTo(String to) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            ((EbxmlElement)mh.getTo().getPartyIds().next()).setValue(to);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setTo(String toPartyId, String type) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            PartyId pid = mh.getTo().addPartyId();
            pid.setType(type);
            pid.setValue(toPartyId);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setService(String service, String type) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            mh.getService().setValue(service);
            mh.getService().setType(type);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setService(String service) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            mh.getService().setValue(service);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setAction(String action) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            MessageHeader mh = ebh.getMessageHeader();
            mh.getAction().setValue(action);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void initMessageHeader() {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            MessageHeader mh = ebh.addMessageHeader();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void initNameSpace() {
        try {
            SOAPPart sp = this.message.getSOAPPart();
            SOAPEnvelope env = sp.getEnvelope();
            env.addNamespaceDeclaration("xlink", "http://www.w3.org/1999/xlink");
            env.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            env.addNamespaceDeclaration("soap-env", "http://schemas.xmlsoap.org/soap/envelope/");
            Name name = env.createName("schemaLocation", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
            env.addAttribute(name, "http://schemas.xmlsoap.org/soap/envelope/ http://www.oasis-open.org/committees/ebxml-msg/schema/envelope.xsd");
            SOAPHeader header = env.getHeader();
            header.addNamespaceDeclaration("eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            Name name2 = env.createName("schemaLocation", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
            header.addAttribute(name2, "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPBody body = env.getBody();
            Name name3 = env.createName("schemaLocation", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
            body.addNamespaceDeclaration("eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            body.addAttribute(name3, "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public boolean validateTimestamp() {
        return true;
    }

    public String getMsgHeaderAsString() throws IOException, SOAPException {
        SecurityUtils sutil = new SecurityUtils();
        return new String(sutil.SOAPPartTOBytes(this));
    }

    public byte[] getMsgHeaderAsBytes() throws IOException, SOAPException {
        String message = this.getMsgHeaderAsString();
        if (message == null) {
            return null;
        }
        return message.getBytes();
    }

    public String getMsgAsString() throws IOException, SOAPException {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            this.writeTo(bo);
            bo.flush();
            return new String(bo.toByteArray());
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            return null;
        }
    }

    public byte[] getMsgAsBytes() throws IOException, SOAPException {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            this.writeTo(bo);
            bo.flush();
            return bo.toByteArray();
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            return null;
        }
    }
}

