/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.packaging.impl;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.message.packaging.Description;
import org.kldp.ebmsh.message.packaging.EbxmlHeader;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.EbxmlMessageFactory;
import org.kldp.ebmsh.message.packaging.ErrorElement;
import org.kldp.ebmsh.message.packaging.ErrorList;
import org.kldp.ebmsh.message.packaging.impl.EbxmlHeaderImpl;
import org.kldp.ebmsh.message.packaging.impl.EbxmlMessageImpl;
import org.kldp.util.log.LogUtil;

public class ErrorMessage
extends EbxmlMessageImpl {
    private static Log log = LogFactory.getLog(ErrorMessage.class);

    public ErrorMessage() {
    }

    public ErrorMessage(EbxmlMessage message, EbxmlMessageFactory factory) throws SOAPException {
        super(message, factory);
        this.initMessageHeader();
    }

    public Iterator getErrors() {
        try {
            EbxmlHeaderImpl ebh = (EbxmlHeaderImpl)this.getEbxmlHeader();
            return ebh.getChildElements("ErrorList");
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            return null;
        }
    }

    public ErrorList getErrorList() {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            return ebh.getErrorList();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            return null;
        }
    }

    public void setError(String errorCode, String severity, String location, String description) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            log.info((Object)("set error " + location + " " + description));
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            ErrorList el = ebh.getErrorList();
            ErrorElement err = el.addErrorElement();
            err.setErrorCode(errorCode);
            err.setServerity(severity);
            err.setLocation(location);
            Description d = err.addDescription();
            d.setValue(description);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void setError(String codeContext, String errorCode, String severity, String location, String description) {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            log.info((Object)("set error with context " + location + " " + description + " " + codeContext));
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            ErrorList el = ebh.getErrorList();
            el.setHighestSeverity("Error");
            ErrorElement err = el.addErrorElement();
            err.setCodeContext(codeContext);
            err.setErrorCode(errorCode);
            err.setServerity(severity);
            err.setLocation(location);
            Description d = err.addDescription();
            d.setValue(description);
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public void initMessageHeader() {
        try {
            EbxmlHeader ebh = this.getEbxmlHeader();
            if (!ebh.hasMessageHeader()) {
                log.info((Object)"initMessageHeader() \ub97c \uba3c\uc800 \ud638\ucd9c\ud574\uc11c MessageHeader\ub97c \ucd08\uae30\ud654\uc2dc\ucf1c \uc8fc\uc138\uc694.");
            }
            ebh.addErrorList();
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }

    public boolean isDeliveryFailure() {
        boolean deliveryFailure = false;
        Iterator i = this.getErrors();
        while (i.hasNext()) {
            ErrorList el = (ErrorList)i.next();
            try {
                Iterator ii = el.getErrorElements();
                while (ii.hasNext()) {
                    ErrorElement err = (ErrorElement)ii.next();
                    if (err.getErrorCode().compareTo("DeliveryFailure") != 0) continue;
                    deliveryFailure = true;
                }
            }
            catch (SOAPException e) {
                log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            }
        }
        return deliveryFailure;
    }

    public ArrayList getErrorsToArrayList() throws SOAPException {
        ArrayList<ErrorElement> al = new ArrayList<ErrorElement>();
        Iterator i = this.getErrors();
        while (i.hasNext()) {
            ErrorList el = (ErrorList)i.next();
            try {
                Iterator ii = el.getErrorElements();
                while (ii.hasNext()) {
                    ErrorElement err = (ErrorElement)ii.next();
                    al.add(err);
                }
            }
            catch (SOAPException e) {
                log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            }
        }
        return al;
    }
}

