/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.packaging.validation;

import com.sun.org.apache.xml.internal.utils.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.message.packaging.EbxmlBody;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.Reference;
import org.kldp.ebmsh.message.packaging.validation.EbmsEbxmlValidationException;
import org.kldp.util.log.LogUtil;

public class BodyValidator {
    private static Log log = LogFactory.getLog(BodyValidator.class);
    private static BodyValidator instance = new BodyValidator();

    private BodyValidator() {
    }

    public static BodyValidator getInstance() {
        return instance;
    }

    public void validate(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        this.payloadValidation(ebxmlMessage);
    }

    private void payloadValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        try {
            log.info((Object)" Payload validation.");
            EbxmlBody ebxmlBody = ebxmlMessage.getEbxmlBody();
            if (!ebxmlBody.hasManifest()) {
                return;
            }
            ArrayList references = ebxmlBody.getManifest().getReferences();
            ArrayList<String> referenceContentIds = new ArrayList<String>();
            int i = 0;
            while (i < references.size()) {
                Reference reference = (Reference)references.get(i);
                String xlinkRef = reference.getXlinkRef();
                log.info((Object)("  Reference's XlinkRef check. XlinkRef : " + xlinkRef));
                if (!xlinkRef.startsWith("cid:")) {
                    log.fatal((Object)"   [ Error ] - XlinkRef not start 'cid:'.");
                    throw new EbmsEbxmlValidationException("MimeProblem", "Error", "No such cid in the reference element", "Payload validation");
                }
                if (!this.isValidUri(xlinkRef)) {
                    log.fatal((Object)"   [ Error ] - XlinkRef is not URI.");
                    throw new EbmsEbxmlValidationException("MimeProblem", "Error", "The xlink:href element of a Manifest/Reference element must be a URI.", "Payload validation");
                }
                referenceContentIds.add(xlinkRef.substring(4));
                ++i;
            }
            Iterator iter = ebxmlMessage.getAttachments();
            ArrayList<String> attachmentPartContentIds = new ArrayList<String>();
            while (iter.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)iter.next();
                String cid = attachmentPart.getContentId();
                if (cid.startsWith("<")) {
                    cid = cid.substring(cid.indexOf("<") + 1, cid.length() - 1);
                }
                attachmentPartContentIds.add(cid);
            }
            log.info((Object)"  Check reference's XlinkRef value existance in attachment part.");
            int i2 = 0;
            while (i2 < referenceContentIds.size()) {
                String contentId = (String)referenceContentIds.get(i2);
                if (!attachmentPartContentIds.contains(contentId)) {
                    log.fatal((Object)"   [ Error ] - A manifest entry refers to non-existent payload.");
                    throw new EbmsEbxmlValidationException("MimeProblem", "Error", "A manifest entry refers to non-existent payload.", "Payload validation");
                }
                ++i2;
            }
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlValidationException("OtherXml", "Error", "Can't payload validation.\n" + LogUtil.stackTraceToString((Throwable)e), "Payload validation");
        }
    }

    private boolean isValidUri(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (URI.MalformedURIException e) {
            return false;
        }
    }
}

