/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.packaging.validation;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.cpa.CanReceive;
import org.kldp.ebmsh.cpa.Cpa;
import org.kldp.ebmsh.cpa.CpaManagerFactory;
import org.kldp.ebmsh.cpa.DeliveryChannel;
import org.kldp.ebmsh.cpa.PartyInfo;
import org.kldp.ebmsh.message.packaging.EbxmlHeader;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.From;
import org.kldp.ebmsh.message.packaging.MessageOrder;
import org.kldp.ebmsh.message.packaging.PartyId;
import org.kldp.ebmsh.message.packaging.SequenceNumber;
import org.kldp.ebmsh.message.packaging.Service;
import org.kldp.ebmsh.message.packaging.validation.EbmsEbxmlValidationException;
import org.kldp.ebmsh.message.util.MessageUtil;
import org.kldp.util.log.LogUtil;

public class HeaderValidator {
    private static Log log = LogFactory.getLog(HeaderValidator.class);
    private static HeaderValidator instance = new HeaderValidator();

    private HeaderValidator() {
    }

    public static HeaderValidator getInstance() {
        return instance;
    }

    public void validate(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        log.info((Object)"Start MessageHeader validation.");
        this.cpaValidation(ebxmlMessage);
        this.fromValidation(ebxmlMessage);
        this.toValidation(ebxmlMessage);
        this.actionValidation(ebxmlMessage);
        this.syncValidation(ebxmlMessage);
        this.serviceValidation(ebxmlMessage);
        this.ackRequestedValidation(ebxmlMessage);
        this.messageOrderValidation(ebxmlMessage);
        this.duplicateEliminationValidation(ebxmlMessage);
    }

    private void cpaValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        log.info((Object)" CPA validation.");
        String cpaId = ebxmlMessage.getCPAId();
        Cpa cpa = new CpaManagerFactory().createInstance().getCpa(cpaId);
        if (cpa == null) {
            log.fatal((Object)("    [ Error ] - Cpa: " + cpaId + " can't find from ebXML engine."));
            EbmsEbxmlValidationException ev = new EbmsEbxmlValidationException("ValueNotRecognized", "Error", "Check your cpaid, there's no such kinds of cpa id." + cpaId, "CPA Validation");
            throw ev;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fromValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        try {
            log.info((Object)" From element validation.");
            From from = ebxmlMessage.getEbxmlHeader().getMessageHeader().getFrom();
            Iterator iter = from.getPartyIds();
            if (!iter.hasNext()) {
                throw new EbmsEbxmlValidationException("Inconsistent", "Error", "From PartyId is null.", "From validation");
            }
            while (true) {
                if (!iter.hasNext()) {
                    log.info((Object)"  Search the ParyInfo from CPA corresponds to the From of ebXML Message.");
                    String cpaId = ebxmlMessage.getCPAId();
                    String fromStr = ebxmlMessage.getFrom();
                    log.info((Object)("   ebXML message From: " + fromStr));
                    Cpa cpa = new CpaManagerFactory().createInstance().getCpa(cpaId);
                    PartyInfo partyInfo = cpa.getPartyInfo(fromStr);
                    if (partyInfo != null) return;
                    throw new EbmsEbxmlValidationException("ValueNotRecognized", "Error", "Can't find PartyInfo correspond to the From of ebXML Message.", "From validation");
                }
                PartyId partyId = (PartyId)iter.next();
                String type = partyId.getType();
                String value = partyId.getValue();
                log.info((Object)("  PartyId type: " + type + "\tvalue: " + value));
                if (type != null) continue;
                log.info((Object)"   PartyId type is null. Check PartyId element value is URI.");
                if (!this.isValidUrl(value)) break;
            }
            log.fatal((Object)"    [ Error ] - PartyId element value is not URI.");
            throw new EbmsEbxmlValidationException("ValueNotRecognized", "Error", "From PartyId is not uri.", "From validation");
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlValidationException("OtherXml", "Error", "Can't From element validation.\n" + LogUtil.stackTraceToString((Throwable)e), "From validation");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void toValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        try {
            log.info((Object)" To element validation.");
            From from = ebxmlMessage.getEbxmlHeader().getMessageHeader().getFrom();
            Iterator iter = from.getPartyIds();
            if (!iter.hasNext()) {
                throw new EbmsEbxmlValidationException("Inconsistent", "Error", "To PartyId is null.", "To validation");
            }
            while (true) {
                if (!iter.hasNext()) {
                    log.info((Object)"  Search the ParyInfo from CPA corresponds to the To of ebXML Message.");
                    String cpaId = ebxmlMessage.getCPAId();
                    String toStr = ebxmlMessage.getTo();
                    log.info((Object)("   ebXML message To: " + toStr));
                    Cpa cpa = new CpaManagerFactory().createInstance().getCpa(cpaId);
                    PartyInfo partyInfo = cpa.getPartyInfo(toStr);
                    if (partyInfo != null) return;
                    throw new EbmsEbxmlValidationException("ValueNotRecognized", "Error", "Can't find PartyInfo correspond to the To of ebXML Message.", "To validation");
                }
                PartyId partyId = (PartyId)iter.next();
                String type = partyId.getType();
                String value = partyId.getValue();
                log.info((Object)("  PartyId type: " + type + "\tvalue: " + value));
                if (type != null) continue;
                log.info((Object)"   PartyId type is null. Check PartyId element value is URI.");
                if (!this.isValidUrl(value)) break;
            }
            log.fatal((Object)"    [ Error ] - PartyId element value is not URI.");
            throw new EbmsEbxmlValidationException("ValueNotRecognized", "Error", "To PartyId is not uri.", "To validation");
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlValidationException("OtherXml", "Error", "Can't To element validation.\n" + LogUtil.stackTraceToString((Throwable)e), "To validation");
        }
    }

    private void serviceValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        block7: {
            try {
                log.info((Object)" Service element validation.");
                Service service = ebxmlMessage.getEbxmlHeader().getMessageHeader().getService();
                String type = service.getType();
                String value = service.getValue();
                log.info((Object)("  Service type: " + type + "\tvalue: " + value));
                if (MessageUtil.isSystemLevelActionMessage(ebxmlMessage)) {
                    log.info((Object)"  Action is Acknowledgment. Check Service is urn:oasis:names:tc:ebxml-msg:service.");
                    if (!value.equals("urn:oasis:names:tc:ebxml-msg:service")) {
                        log.fatal((Object)("   [ Error ] - Service is not urn:oasis:names:tc:ebxml-msg:service. The service of ebXML message : " + value));
                        throw new EbmsEbxmlValidationException("ValueNotRecognized", "Error", "Service value not recognized", "Service validation.");
                    }
                    break block7;
                }
                if (type == null) {
                    log.info((Object)"   Service type is null. Check Service element value is URI.");
                    if (!this.isValidUrl(value)) {
                        log.fatal((Object)"    [ Error ] - Service element value is not URI.");
                        throw new EbmsEbxmlValidationException("ValueNotRecognized", "Error", "Service is not uri.", "Service validation");
                    }
                }
                log.info((Object)"  Search Service to the CPA.");
                String cpaId = ebxmlMessage.getCPAId();
                String to = ebxmlMessage.getTo();
                Cpa cpa = new CpaManagerFactory().createInstance().getCpa(cpaId);
                PartyInfo partyInfo = cpa.getPartyInfo(to);
                String serviceStr = partyInfo.getService();
                if (value.equals(serviceStr)) {
                    log.info((Object)"   The service name is same.");
                    break block7;
                }
                log.fatal((Object)"   The service name is not same.");
                log.fatal((Object)("    Message service: " + value + "\tCPA service: " + serviceStr));
                throw new EbmsEbxmlValidationException("ValueNotRecognized", "Error", "Service value not recognized.", "Service validation.");
            }
            catch (SOAPException e) {
                throw new EbmsEbxmlValidationException("OtherXml", "Error", "Can't Service element validation.\n" + LogUtil.stackTraceToString((Throwable)e), "Service validation");
            }
        }
    }

    private void actionValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        log.info((Object)" Action validation.");
        if (MessageUtil.isSystemLevelActionMessage(ebxmlMessage)) {
            return;
        }
        log.info((Object)"  Search Action from CPA.");
        boolean findStatus = false;
        String cpaId = ebxmlMessage.getCPAId();
        String ebXMLMessageAction = ebxmlMessage.getAction();
        Cpa cpa = new CpaManagerFactory().createInstance().getCpa(cpaId);
        String to = ebxmlMessage.getTo();
        PartyInfo partyInfo = cpa.getPartyInfo(to);
        CanReceive[] canReceiveArray = partyInfo.getCanReceives();
        int i = 0;
        while (i < canReceiveArray.length) {
            CanReceive canReceive = canReceiveArray[i];
            String cpaAction = canReceive.getAction();
            if (ebXMLMessageAction.equals(cpaAction)) {
                log.info((Object)("   " + ebXMLMessageAction + " == " + cpaAction));
                findStatus = true;
                break;
            }
            log.info((Object)("   " + ebXMLMessageAction + " != " + cpaAction));
            ++i;
        }
        if (!findStatus) {
            log.fatal((Object)"    [ Error ] - Can't find ebXML message action.");
            throw new EbmsEbxmlValidationException("ValueNotRecognized", "Error", "No such kinds of Action.", "Action validation");
        }
    }

    private void duplicateEliminationValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        try {
            log.info((Object)" DuplicateElimination validation.");
            boolean messageDuplicateEliminationMode = false;
            boolean cpaDuplicateEliminationMode = false;
            if (ebxmlMessage.getEbxmlHeader().getMessageHeader().hasDuplicateElimination()) {
                messageDuplicateEliminationMode = true;
            }
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            String from = ebxmlMessage.getFrom();
            String action = ebxmlMessage.getAction();
            DeliveryChannel deliveryChannel = null;
            if (MessageUtil.isSystemLevelActionMessage(ebxmlMessage)) {
                PartyInfo partyInfo = cpa.getPartyInfo(from);
                String defaultMshChannelId = partyInfo.getDefaultMshChannelId();
                deliveryChannel = partyInfo.getDeliveryChannel(defaultMshChannelId);
            } else {
                deliveryChannel = cpa.getPartyInfo(from).getDeliveryChannelByAction(action);
            }
            String duplicateElimination = deliveryChannel.getDuplicateElimination();
            if (duplicateElimination.equals("always")) {
                cpaDuplicateEliminationMode = true;
            } else if (duplicateElimination.equals("never")) {
                cpaDuplicateEliminationMode = false;
            } else if (duplicateElimination.equals("perMessage")) {
                return;
            }
            log.info((Object)("  DuplicateElimination Mode - Message: " + messageDuplicateEliminationMode + "\tCPA: " + cpaDuplicateEliminationMode));
            if (messageDuplicateEliminationMode != cpaDuplicateEliminationMode) {
                throw new EbmsEbxmlValidationException("Inconsistent", "Error", "DuplicateElimination inconsistent with CPA.", "DuplicateElimination validation");
            }
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlValidationException("OtherXml", "Error", "Can't DuplicateElimination validation.\n" + LogUtil.stackTraceToString((Throwable)e), "DuplicateElimination validation");
        }
    }

    private void messageOrderValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        try {
            log.info((Object)" MessageOrder validation.");
            EbxmlHeader ebxmlHeader = ebxmlMessage.getEbxmlHeader();
            if (!ebxmlHeader.hasMessageOrder()) {
                log.info((Object)"  MessageOrder does not exist.");
                return;
            }
            MessageOrder messageOrder = ebxmlHeader.getMessageOrder();
            SequenceNumber sequenceNumber = messageOrder.getSequenceNumber();
            int sequenceNumberInt = Integer.parseInt(sequenceNumber.getValue());
            if (sequenceNumberInt < 0 || 99999999 < sequenceNumberInt) {
                log.fatal((Object)("  [ Error ] - Current sequence number: " + sequenceNumberInt + "\tSequence number is smaller than " + 0 + " or bigger than " + 99999999 + "."));
                throw new EbmsEbxmlValidationException("Inconsistent", "Error", "Sequence number is smaller than 0 or bigger than 99999999.", "MessageOrder validation");
            }
            if (ebxmlMessage.getEbxmlHeader().hasSyncReply()) {
                throw new EbmsEbxmlValidationException("Inconsistent", "Error", "Sync and MessageOrder element can't appear same time that message.", "MessageOrder validation");
            }
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlValidationException("OtherXml", "Error", "Can't DuplicateElimination validation.\n" + LogUtil.stackTraceToString((Throwable)e), "DuplicateElimination validation");
        }
    }

    private void ackRequestedValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        try {
            log.info((Object)" AckRequested validation.");
            boolean messageAckRequested = false;
            if (ebxmlMessage.getEbxmlHeader().hasAckRequested()) {
                messageAckRequested = true;
            }
            String cpaId = ebxmlMessage.getCPAId();
            String from = ebxmlMessage.getFrom();
            String action = ebxmlMessage.getAction();
            if (messageAckRequested) {
                if (action.equals("Acknowledgment")) {
                    log.fatal((Object)"  [ Error ] - Acknowledgment ebXML message can't contain AckRequested element.");
                    throw new EbmsEbxmlValidationException("Inconsistent", "Error", "Acknowledgment ebXML message can't contain AckRequested element.", "AckRequested validation");
                }
                if (action.equals("ErrorMessage")) {
                    log.fatal((Object)"  [ Error ] - ErrorMessage ebXML message can't contain AckRequested element.");
                    throw new EbmsEbxmlValidationException("Inconsistent", "Error", "ErrorMessage ebXML message can't contain AckRequested element.", "AckRequested validation");
                }
            } else if (action.equals("Acknowledgment") || action.equals("ErrorMessage")) {
                return;
            }
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(cpaId);
            PartyInfo partyInfo = cpa.getPartyInfo(from);
            DeliveryChannel deliveryChannel = null;
            if (MessageUtil.isSystemLevelActionMessage(ebxmlMessage)) {
                String defaultMshChannelId = partyInfo.getDefaultMshChannelId();
                deliveryChannel = partyInfo.getDeliveryChannel(defaultMshChannelId);
            } else {
                deliveryChannel = cpa.getPartyInfo(from).getDeliveryChannelByAction(action);
            }
            String cpaAckRequested = deliveryChannel.getAckRequested();
            log.info((Object)("  AckRequested Mode - Message: " + messageAckRequested + "\tCPA: " + cpaAckRequested));
            if (messageAckRequested ? cpaAckRequested.equals("never") : cpaAckRequested.equals("always")) {
                throw new EbmsEbxmlValidationException("Inconsistent", "Error", "AckRequested inconsistent with CPA.", "AckRequested validation");
            }
            if (messageAckRequested) {
                log.info((Object)"  Check AckSignatureRequested.");
                boolean messageAckSignatureRequested = false;
                messageAckSignatureRequested = ebxmlMessage.getEbxmlHeader().getAckRequested().getSigned();
                String cpaAckSignatureRequested = deliveryChannel.getAckSignatureRequested();
                log.info((Object)("  AckSignatureRequested Mode - Message: " + messageAckSignatureRequested + "\tCPA: " + cpaAckSignatureRequested));
                if (messageAckSignatureRequested ? cpaAckSignatureRequested.equals("never") || cpaAckSignatureRequested.equals("perMessage") : cpaAckSignatureRequested.equals("always")) {
                    throw new EbmsEbxmlValidationException("Inconsistent", "Error", "AckSignatureRequested inconsistent with CPA.", "AckRequested validation");
                }
            }
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlValidationException("OtherXml", "Error", "Can't AckRequested validation.\n" + LogUtil.stackTraceToString((Throwable)e), "AckRequested validation");
        }
    }

    private void timeToLiveValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        log.info((Object)" TimeToLive validation.");
        String timeToLive = ebxmlMessage.getTimeToLive();
        if (timeToLive == null) {
            log.info((Object)"  TimeToLive does not exist.");
            return;
        }
        Date timestamp = MessageUtil.utcToDate(timeToLive);
        if (timestamp.before(new Date())) {
            log.fatal((Object)("   Message TimeToLive: " + timestamp + "\tCurrent time: " + new Date()));
            throw new EbmsEbxmlValidationException("TimeToLiveExpired", "Error", "Invalid TimeToLive.", "TimeToLive validation");
        }
    }

    private void syncValidation(EbxmlMessage ebxmlMessage) throws EbmsEbxmlValidationException {
        try {
            log.info((Object)" SyncReply validation.");
            boolean messageSyncReplyMode = false;
            boolean cpaSyncReplyMode = false;
            EbxmlHeader ebxmlHeader = ebxmlMessage.getEbxmlHeader();
            if (ebxmlHeader.hasSyncReply()) {
                messageSyncReplyMode = true;
            }
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            String syncReplyMode = null;
            if (MessageUtil.isSystemLevelActionMessage(ebxmlMessage)) {
                PartyInfo partyInfo = cpa.getPartyInfo(ebxmlMessage.getFrom());
                String defaultMshChannelId = partyInfo.getDefaultMshChannelId();
                syncReplyMode = partyInfo.getDeliveryChannel(defaultMshChannelId).getSyncReplyMode();
            } else {
                syncReplyMode = cpa.getPartyInfo(ebxmlMessage.getFrom()).getDeliveryChannelByAction(ebxmlMessage.getAction()).getSyncReplyMode();
            }
            if (syncReplyMode.equals("none")) {
                cpaSyncReplyMode = false;
            } else if (syncReplyMode.equals("mshSignalsOnly") || syncReplyMode.equals("signalsOnly") || syncReplyMode.equals("responseOnly") || syncReplyMode.equals("signalsAndResponse")) {
                cpaSyncReplyMode = true;
            }
            log.info((Object)("  SyncReply Mode - Message: " + messageSyncReplyMode + "\tCPA: " + syncReplyMode));
            if (messageSyncReplyMode != cpaSyncReplyMode) {
                throw new EbmsEbxmlValidationException("Inconsistent", "Error", "SyncReplyMode inconsistent with CPA.", "SyncReplyMode validation");
            }
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlValidationException("OtherXml", "Error", "Can't SyncReply validation.\n" + LogUtil.stackTraceToString((Throwable)e), "SyncReply validation");
        }
    }

    private boolean isValidUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

