/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.persistant;

import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.soap.SOAPException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.persistant.AckMessage;
import org.kldp.ebmsh.message.persistant.DbTemplate;
import org.kldp.ebmsh.message.persistant.DbWorker;
import org.kldp.ebmsh.message.persistant.EbmsPersistantException;
import org.kldp.util.io.FileIoUtil;

public class AckMessageDAO {
    public AckMessage getAckMessageByRefToMessageId(String refToMessageId) throws EbmsPersistantException {
        AckMessage ackMessage = null;
        DbTemplate dbTemplate = new DbTemplate();
        final String queryStr = "select * from " + EbmsConstants.bizboxDatabaseHeaderName + "AckMessage where RefToMessageId=?";
        final Object[] parameters = new Object[]{refToMessageId};
        ackMessage = (AckMessage)dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                BeanHandler resultSetHandler = new BeanHandler(AckMessage.class);
                AckMessage ackMessage = null;
                try {
                    ackMessage = (AckMessage)runner.query(_conn, queryStr, parameters, (ResultSetHandler)resultSetHandler);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(0, e.getErrorCode(), e);
                }
                return ackMessage;
            }
        });
        return ackMessage;
    }

    public void insertAckMessage(EbxmlMessage ackMessage) throws EbmsPersistantException {
        try {
            String messageId = ackMessage.getMessageId();
            String refToMessageId = ackMessage.getEbxmlHeader().getAcknowledgment().getRefToMessageId().getValue();
            String ackFilePath = String.valueOf(FileIoUtil.fileSeparatorAddOrNone((String)"outgoing")) + FileIoUtil.fileSeparatorAddOrNone((String)"ackmessage") + messageId;
            final String queryStr = "insert into " + EbmsConstants.bizboxDatabaseHeaderName + "AckMessage(MessageId, RefToMessageId, ACKFileName) values(?, ?, ?)";
            final Object[] parameters = new Object[]{messageId, refToMessageId, ackFilePath};
            DbTemplate dbTemplate = new DbTemplate();
            dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws EbmsPersistantException {
                    QueryRunner runner = new QueryRunner();
                    try {
                        runner.update(_conn, queryStr, parameters);
                    }
                    catch (SQLException e) {
                        throw new EbmsPersistantException(1, e.getErrorCode(), e);
                    }
                    return null;
                }
            });
        }
        catch (SOAPException e) {
            throw new EbmsPersistantException(1, 0, e);
        }
        catch (EbmsPersistantException e) {
            throw e;
        }
    }

    public void updateAckMessage(EbxmlMessage ackMessage) throws EbmsPersistantException {
        try {
            String messageId = ackMessage.getMessageId();
            String refToMessageId = ackMessage.getEbxmlHeader().getAcknowledgment().getRefToMessageId().getValue();
            String ackFilePath = String.valueOf(FileIoUtil.fileSeparatorAddOrNone((String)"outgoing")) + FileIoUtil.fileSeparatorAddOrNone((String)"ackmessage") + messageId;
            final String queryStr = "update " + EbmsConstants.bizboxDatabaseHeaderName + "AckMessage set RefToMessageId=?, ACKFileName=? where MessageId=?";
            final Object[] parameters = new Object[]{refToMessageId, ackFilePath, messageId};
            DbTemplate dbTemplate = new DbTemplate();
            dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws EbmsPersistantException {
                    QueryRunner runner = new QueryRunner();
                    try {
                        runner.update(_conn, queryStr, parameters);
                    }
                    catch (SQLException e) {
                        throw new EbmsPersistantException(1, e.getErrorCode(), e);
                    }
                    return null;
                }
            });
        }
        catch (SOAPException e) {
            throw new EbmsPersistantException(1, 0, e);
        }
        catch (EbmsPersistantException e) {
            throw e;
        }
    }
}

