/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.persistant;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.persistant.DbTemplate;
import org.kldp.ebmsh.message.persistant.DbWorker;
import org.kldp.ebmsh.message.persistant.DuplicateMessage;
import org.kldp.ebmsh.message.persistant.EbmsPersistantException;

public class DuplicateMessageDAO {
    public boolean duplicatePrevention(EbxmlMessage ebxmlMessage, long nowTime) throws EbmsPersistantException {
        DuplicateMessage duplicateMessage = null;
        String messageId = ebxmlMessage.getMessageId();
        Timestamp nowTimeTimestamp = new Timestamp(nowTime);
        final String queryStr = "select * from " + EbmsConstants.bizboxDatabaseHeaderName + "DuplicateMessage where MessageId =? and CheckEndTime >= ?";
        final Object[] parameters = new Object[]{messageId, nowTimeTimestamp};
        DbTemplate dbTemplate = new DbTemplate();
        duplicateMessage = (DuplicateMessage)dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                BeanHandler resultSetHandler = new BeanHandler(DuplicateMessage.class);
                DuplicateMessage duplicateMessage = null;
                try {
                    duplicateMessage = (DuplicateMessage)runner.query(_conn, queryStr, parameters, (ResultSetHandler)resultSetHandler);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return duplicateMessage;
            }
        });
        return duplicateMessage != null;
    }

    public void insertDuplicateMessage(EbxmlMessage ebxmlMessage, long checkEndTime) throws EbmsPersistantException {
        String messageId = ebxmlMessage.getMessageId();
        Timestamp checkEndTimeTimestamp = new Timestamp(checkEndTime);
        final String queryStr = "insert into " + EbmsConstants.bizboxDatabaseHeaderName + "DuplicateMessage(MessageId, CheckEndTime) values(?, ?)";
        final Object[] parameters = new Object[]{messageId, checkEndTimeTimestamp};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }

    public void updateDuplicateMessage(EbxmlMessage ebxmlMessage, long checkEndTime) throws EbmsPersistantException {
        String messageId = ebxmlMessage.getMessageId();
        Timestamp checkEndTimeTimestamp = new Timestamp(checkEndTime);
        final String queryStr = "update " + EbmsConstants.bizboxDatabaseHeaderName + "DuplicateMessage set CheckEndTime=? where MessageId=?";
        final Object[] parameters = new Object[]{checkEndTimeTimestamp, messageId};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }
}

