/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.persistant;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.persistant.DbTemplate;
import org.kldp.ebmsh.message.persistant.DbWorker;
import org.kldp.ebmsh.message.persistant.EbmsPersistantException;
import org.kldp.ebmsh.message.persistant.MessageStore;
import org.kldp.ebmsh.message.util.MessageUtil;

public class MessageStoreDAO {
    private static final Log log = LogFactory.getLog(MessageStoreDAO.class);

    public void insertMessageStore(EbxmlMessage ebxmlMessage) throws EbmsPersistantException {
        final String queryStr = "insert into " + EbmsConstants.bizboxDatabaseHeaderName + "MessageStore(MessageId, CpaId, FromPartyId, ToPartyId, ConversationId, Service, Action, TimeStamp) values(?, ?, ?, ?, ?, ?, ?, ?)";
        String messageId = ebxmlMessage.getMessageId();
        String cpaId = ebxmlMessage.getCPAId();
        String from = ebxmlMessage.getFrom();
        String to = ebxmlMessage.getTo();
        String conversationId = ebxmlMessage.getConversationId();
        String service = ebxmlMessage.getService();
        String action = ebxmlMessage.getAction();
        Date messageDate = MessageUtil.utcToDate(ebxmlMessage.getTimestamp());
        Timestamp timestamp = new Timestamp(messageDate.getTime());
        final Object[] parameters = new Object[]{messageId, cpaId, from, to, conversationId, service, action, timestamp};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }

    public void updateMessageStore(EbxmlMessage ebxmlMessage) throws EbmsPersistantException {
        final String queryStr = "update " + EbmsConstants.bizboxDatabaseHeaderName + "MessageStore set CpaId=?, FromPartyId=?, ToPartyId=?, ConversationId=?, Service=?, Action=?, TimeStamp=? where MessageId=?";
        String messageId = ebxmlMessage.getMessageId();
        String cpaId = ebxmlMessage.getCPAId();
        String from = ebxmlMessage.getFrom();
        String to = ebxmlMessage.getTo();
        String conversationId = ebxmlMessage.getConversationId();
        String service = ebxmlMessage.getService();
        String action = ebxmlMessage.getAction();
        Date messageDate = MessageUtil.utcToDate(ebxmlMessage.getTimestamp());
        Timestamp timestamp = new Timestamp(messageDate.getTime());
        final Object[] parameters = new Object[]{cpaId, from, to, conversationId, service, action, timestamp, messageId};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }

    public MessageStore getMessageStoreMessage(String messageId) throws EbmsPersistantException {
        MessageStore messageStore = null;
        DbTemplate dbTemplate = new DbTemplate();
        final String queryStr = "select * from " + EbmsConstants.bizboxDatabaseHeaderName + "Messagestore where MessageId=?";
        final Object[] parameters = new Object[]{messageId};
        messageStore = (MessageStore)dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                BeanHandler resultSetHandler = new BeanHandler(MessageStore.class);
                MessageStore messageStore = null;
                try {
                    messageStore = (MessageStore)runner.query(_conn, queryStr, parameters, (ResultSetHandler)resultSetHandler);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(0, e.getErrorCode(), e);
                }
                return messageStore;
            }
        });
        return messageStore;
    }
}

