/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.transport;

import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.cpa.Cpa;
import org.kldp.ebmsh.cpa.CpaManagerFactory;
import org.kldp.ebmsh.cpa.EbmsCpaException;
import org.kldp.ebmsh.cpa.PartyInfo;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.persistant.EbmsPersistantException;
import org.kldp.ebmsh.message.persistant.OutgoingMessageStatusConstraints;
import org.kldp.ebmsh.message.persistant.PersistantStorage;
import org.kldp.ebmsh.message.transport.EbmsTransportException;
import org.kldp.ebmsh.message.transport.HttpTransport;
import org.kldp.ebmsh.message.transport.rm.RMSender;

public class EbxmlMessageSender {
    private static Log log = LogFactory.getLog(EbxmlMessageSender.class);

    public EbxmlMessage sendMessageForFaultHandler(EbxmlMessage ebxmlMessage, String endpoint) throws EbmsTransportException {
        try {
            EbxmlMessage responseEbxmlMessage = null;
            responseEbxmlMessage = new HttpTransport().sendMessageForMultipart(ebxmlMessage, endpoint);
            return responseEbxmlMessage;
        }
        catch (EbmsCpaException e) {
            throw new EbmsTransportException(1, 0, e);
        }
        catch (EbmsTransportException e) {
            throw e;
        }
        catch (EbmsPersistantException e) {
            throw new EbmsTransportException(1, 0, e);
        }
    }

    public EbxmlMessage sendMessage(EbxmlMessage ebxmlMessage) throws EbmsTransportException {
        try {
            EbxmlMessage responseEbxmlMessage = null;
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            if (cpa == null) {
                throw new EbmsCpaException(1, 0, "CPA\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
            PartyInfo party = cpa.getPartyInfo(ebxmlMessage.getTo());
            if (party == null) {
                throw new EbmsCpaException(1, 0, "CPA\uc5d0 party\uc815\ubcf4\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
            String endpoint = party.getEndpointsUnderTransport(ebxmlMessage.getAction())[0];
            if (ebxmlMessage.getEbxmlHeader().hasAckRequested()) {
                new RMSender().sendMessage(ebxmlMessage);
            } else {
                responseEbxmlMessage = new HttpTransport().sendMessageForMultipart(ebxmlMessage, endpoint);
            }
            new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.success);
            return responseEbxmlMessage;
        }
        catch (SOAPException e) {
            try {
                new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.fail);
            }
            catch (EbmsPersistantException ex) {
                throw new EbmsTransportException(1, 0, ex);
            }
            throw new EbmsTransportException(1, 0, e);
        }
        catch (EbmsCpaException e) {
            try {
                new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.fail);
            }
            catch (EbmsPersistantException ex) {
                throw new EbmsTransportException(1, 0, ex);
            }
            throw new EbmsTransportException(1, 0, e);
        }
        catch (EbmsTransportException e) {
            try {
                new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.fail);
            }
            catch (EbmsPersistantException ex) {
                throw new EbmsTransportException(1, 0, ex);
            }
            throw e;
        }
        catch (EbmsPersistantException e) {
            try {
                new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.fail);
            }
            catch (EbmsPersistantException ex) {
                throw new EbmsTransportException(1, 0, ex);
            }
            throw new EbmsTransportException(1, 0, e);
        }
    }

    public EbxmlMessage sendMessageWithoutAction(EbxmlMessage ebxmlMessage) throws EbmsTransportException {
        try {
            EbxmlMessage responseEbxmlMessage = null;
            Cpa cpa = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            if (cpa == null) {
                throw new EbmsCpaException(1, 0, "CPA\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
            PartyInfo party = cpa.getPartyInfo(ebxmlMessage.getTo());
            if (party == null) {
                throw new EbmsCpaException(1, 0, "CPA\uc5d0 party\uc815\ubcf4\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
            String endpoint = party.getEndpointsWithDefaultChannelUnderTransport()[0];
            responseEbxmlMessage = new HttpTransport().sendMessageForMultipart(ebxmlMessage, endpoint);
            new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.success);
            return responseEbxmlMessage;
        }
        catch (EbmsCpaException e) {
            try {
                new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.fail);
            }
            catch (EbmsPersistantException ex) {
                throw new EbmsTransportException(1, 0, ex);
            }
            throw new EbmsTransportException(1, 0, e);
        }
        catch (EbmsTransportException e) {
            try {
                new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.fail);
            }
            catch (EbmsPersistantException ex) {
                throw new EbmsTransportException(1, 0, ex);
            }
            throw e;
        }
    }

    public EbxmlMessage sendMessageWithoutCPA(EbxmlMessage ebxmlMessage, String url) throws EbmsTransportException {
        try {
            EbxmlMessage responseEbxmlMessage = null;
            responseEbxmlMessage = new HttpTransport().sendMessageForMultipart(ebxmlMessage, url);
            new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.success);
            return responseEbxmlMessage;
        }
        catch (EbmsTransportException e) {
            try {
                new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.fail);
            }
            catch (EbmsPersistantException ex) {
                throw new EbmsTransportException(1, 0, ex);
            }
            throw e;
        }
    }

    public void sendMessageRedirect(EbxmlMessage ebxmlMessage, HttpServletResponse response) throws EbmsTransportException {
        try {
            new HttpTransport().redirectForMultipart(ebxmlMessage, response);
            new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.success);
        }
        catch (EbmsTransportException e) {
            try {
                new PersistantStorage().saveOutgoingMessageDbAndFile(ebxmlMessage, OutgoingMessageStatusConstraints.fail);
            }
            catch (EbmsPersistantException ex) {
                throw new EbmsTransportException(1, 0, ex);
            }
            throw e;
        }
    }
}

