/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.kldp.ebmsh.message.packaging.EbmsEbxmlMessageException;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.impl.EbxmlMessageFactoryImpl;
import org.kldp.ebmsh.message.packaging.impl.EbxmlMessageImpl;
import org.kldp.ebmsh.message.util.ByteOutputStream;

public class Serializer {
    public static void serialize(EbxmlMessage aMsg, OutputStream anOs) throws EbmsEbxmlMessageException {
        try {
            if (aMsg.saveRequired()) {
                aMsg.saveChanges();
            }
            Serializer.writeMimeHeaders(aMsg.getMimeHeaders(), anOs);
            Serializer.writeMessage(aMsg, anOs);
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, e);
        }
        catch (IOException e) {
            throw new EbmsEbxmlMessageException(1, 0, e);
        }
        catch (Exception e) {
            throw new EbmsEbxmlMessageException(1, 0, e);
        }
    }

    public static EbxmlMessage deserialize(InputStream anIs) throws EbmsEbxmlMessageException {
        try {
            MimeHeaders hdrs = Serializer.fetchMimeHeaders(anIs);
            EbxmlMessageFactoryImpl mf = new EbxmlMessageFactoryImpl();
            SOAPMessage sm = mf.createMessage(hdrs, anIs);
            EbxmlMessageImpl em = new EbxmlMessageImpl(sm, mf);
            return em;
        }
        catch (IOException e) {
            throw new EbmsEbxmlMessageException(1, 0, "Deserialize \uc5d0\ub7ec -> fetchMimeHeaders()", e);
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, "Deserialize \uc5d0\ub7ec -> createMessage() or EbxmlMessageImpl()", e);
        }
        catch (ClassNotFoundException e) {
            throw new EbmsEbxmlMessageException(1, 0, "Deserialize \uc5d0\ub7ec -> deserialize()", e);
        }
        catch (Exception e) {
            throw new EbmsEbxmlMessageException(1, 0, e);
        }
    }

    private static MimeHeaders fetchMimeHeaders(InputStream aSrcStream) throws IOException, ClassNotFoundException {
        DataInputStream dis = new DataInputStream(aSrcStream);
        int length = dis.readInt();
        byte[] buf = new byte[length];
        dis.read(buf, 0, length);
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Hashtable hash = (Hashtable)ois.readObject();
        return Serializer.hashtableToMime(hash);
    }

    private static void writeMimeHeaders(MimeHeaders aHdrGrp, OutputStream anOut) throws IOException {
        ByteOutputStream bos = new ByteOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(Serializer.mimeToHashtable(aHdrGrp));
        oos.flush();
        oos.close();
        byte[] buf = bos.getBytes();
        DataOutputStream dos = new DataOutputStream(anOut);
        dos.writeInt(buf.length);
        dos.write(buf, 0, buf.length);
        bos.close();
    }

    private static void writeMessage(EbxmlMessage aMsg, OutputStream anOut) throws SOAPException, IOException {
        aMsg.writeTo(anOut);
    }

    private static Hashtable mimeToHashtable(MimeHeaders aHdrList) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        Iterator i = aHdrList.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader mh = (MimeHeader)i.next();
            hash.put(mh.getName(), mh.getValue());
        }
        return hash;
    }

    private static MimeHeaders hashtableToMime(Hashtable aHash) {
        MimeHeaders hdrs = new MimeHeaders();
        Enumeration e = aHash.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            hdrs.addHeader(key, (String)aHash.get(key));
        }
        return hdrs;
    }
}

