/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.moniter.persistant;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.kldp.ebmsh.moniter.persistant.AdminDAO;
import org.kldp.ebmsh.moniter.persistant.BsiMessageStatus;
import org.kldp.ebmsh.moniter.persistant.BsiMessageStatusConstraints;
import org.kldp.ebmsh.moniter.persistant.BsiMessageStatusDAO;
import org.kldp.ebmsh.moniter.persistant.DocumentIdInfo;
import org.kldp.ebmsh.moniter.persistant.DocumentIdInfoDAO;
import org.kldp.ebmsh.moniter.persistant.InComingMessage;
import org.kldp.ebmsh.moniter.persistant.IncomingMessageDAO;
import org.kldp.ebmsh.moniter.persistant.MessageIdAndDocumentIdDAO;
import org.kldp.ebmsh.moniter.persistant.MessageStatus;
import org.kldp.ebmsh.moniter.persistant.MessageStatusConstraints;
import org.kldp.ebmsh.moniter.persistant.MessageStatusDAO;
import org.kldp.ebmsh.moniter.persistant.MessageStore;
import org.kldp.ebmsh.moniter.persistant.MessageStoreDAO;
import org.kldp.ebmsh.moniter.persistant.MoniterPersistantException;
import org.kldp.ebmsh.moniter.persistant.OutgoingMessage;
import org.kldp.ebmsh.moniter.persistant.OutgoingMessageDAO;
import org.kldp.ebmsh.moniter.persistant.SearchResult;
import org.kldp.ebmsh.moniter.persistant.SendSearchResult;
import org.kldp.ebmsh.moniter.persistant.TrackerDAO;

public class EbmsMoniterManager {
    public List searchReceiveMessagesByDocumentId(String documentId, int pageCount) throws MoniterPersistantException {
        try {
            ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
            MessageIdAndDocumentIdDAO messageIdAndDocumentIdDAO = new MessageIdAndDocumentIdDAO();
            IncomingMessageDAO incomingMessageDAO = new IncomingMessageDAO();
            MessageStatusDAO messageStatusDAO = new MessageStatusDAO();
            BsiMessageStatusDAO bsiMessageStatusDAO = new BsiMessageStatusDAO();
            List messageIdList = messageIdAndDocumentIdDAO.getMessageIdsByDocumentId(documentId, pageCount);
            int messageIdSize = messageIdList.size();
            int i = 0;
            while (i < messageIdSize) {
                String messageId = (String)messageIdList.get(i);
                InComingMessage inComingMessage = incomingMessageDAO.getInComingMessage(messageId);
                if (inComingMessage != null) {
                    MessageStatus messageStatus = messageStatusDAO.getMessageStatus(messageId);
                    BsiMessageStatus bsiMessageStatus = bsiMessageStatusDAO.getBsiMessageStatus(messageId);
                    Timestamp receiveTime = inComingMessage.getReceiveTime();
                    int ebxmlMessageStatusValue = MessageStatusConstraints.Unknown;
                    int bsiMessssageStatusValue = BsiMessageStatusConstraints.Unknown;
                    if (messageStatus != null) {
                        ebxmlMessageStatusValue = messageStatus.getStatus();
                    }
                    if (bsiMessageStatus != null) {
                        bsiMessssageStatusValue = bsiMessageStatus.getStatus();
                    }
                    SearchResult searchResult = new SearchResult();
                    searchResult.setDocumentId(documentId);
                    searchResult.setMessageId(messageId);
                    searchResult.setReceiveTime(receiveTime);
                    searchResult.setEbxmlMessageStatus(ebxmlMessageStatusValue);
                    searchResult.setBsiMessageStatus(bsiMessssageStatusValue);
                    resultList.add(searchResult);
                }
                ++i;
            }
            return resultList;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public SearchResult searchReceiveMessageByMessageId(String messageId) throws MoniterPersistantException {
        InComingMessage inComingMessage;
        BsiMessageStatusDAO bsiMessageStatusDAO;
        MessageStatusDAO messageStatusDAO;
        MessageIdAndDocumentIdDAO messageIdAndDocumentIdDAO;
        block6: {
            messageIdAndDocumentIdDAO = new MessageIdAndDocumentIdDAO();
            IncomingMessageDAO incomingMessageDAO = new IncomingMessageDAO();
            messageStatusDAO = new MessageStatusDAO();
            bsiMessageStatusDAO = new BsiMessageStatusDAO();
            inComingMessage = incomingMessageDAO.getInComingMessage(messageId);
            if (inComingMessage != null) break block6;
            return null;
        }
        try {
            String documentId = messageIdAndDocumentIdDAO.getDocumentIdByMessageId(messageId);
            MessageStatus messageStatus = messageStatusDAO.getMessageStatus(messageId);
            BsiMessageStatus bsiMessageStatus = bsiMessageStatusDAO.getBsiMessageStatus(messageId);
            int ebxmlMessageStatusValue = MessageStatusConstraints.Unknown;
            int bsiMessssageStatusValue = BsiMessageStatusConstraints.Unknown;
            if (messageStatus != null) {
                ebxmlMessageStatusValue = messageStatus.getStatus();
            }
            if (bsiMessageStatus != null) {
                bsiMessssageStatusValue = bsiMessageStatus.getStatus();
            }
            Timestamp receiveTime = inComingMessage.getReceiveTime();
            SearchResult searchResult = new SearchResult();
            searchResult.setDocumentId(documentId);
            searchResult.setMessageId(messageId);
            searchResult.setReceiveTime(receiveTime);
            searchResult.setEbxmlMessageStatus(ebxmlMessageStatusValue);
            searchResult.setBsiMessageStatus(bsiMessssageStatusValue);
            return searchResult;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public List searchReceiveMessagesByPeriod(long startTime, long endTime, int pageCount) throws MoniterPersistantException {
        try {
            ArrayList<SearchResult> searchResultList = new ArrayList<SearchResult>();
            MessageIdAndDocumentIdDAO messageIdAndDocumentIdDAO = new MessageIdAndDocumentIdDAO();
            IncomingMessageDAO incomingMessageDAO = new IncomingMessageDAO();
            MessageStatusDAO messageStatusDAO = new MessageStatusDAO();
            BsiMessageStatusDAO bsiMessageStatusDAO = new BsiMessageStatusDAO();
            List inComingMessageInfoList = incomingMessageDAO.getInComingMessagesByPeriod(startTime, endTime, pageCount);
            int inComingMessageInfoSize = inComingMessageInfoList.size();
            int i = 0;
            while (i < inComingMessageInfoSize) {
                InComingMessage inComingMessage = (InComingMessage)inComingMessageInfoList.get(i);
                if (inComingMessage != null) {
                    String messageId = inComingMessage.getMessageId();
                    String documentId = messageIdAndDocumentIdDAO.getDocumentIdByMessageId(messageId);
                    MessageStatus messageStatus = messageStatusDAO.getMessageStatus(messageId);
                    BsiMessageStatus bsiMessageStatus = bsiMessageStatusDAO.getBsiMessageStatus(messageId);
                    int ebxmlMessageStatusValue = MessageStatusConstraints.Unknown;
                    int bsiMessssageStatusValue = BsiMessageStatusConstraints.Unknown;
                    if (messageStatus != null) {
                        ebxmlMessageStatusValue = messageStatus.getStatus();
                    }
                    if (bsiMessageStatus != null) {
                        bsiMessssageStatusValue = bsiMessageStatus.getStatus();
                    }
                    Timestamp receiveTime = inComingMessage.getReceiveTime();
                    SearchResult searchResult = new SearchResult();
                    searchResult.setDocumentId(documentId);
                    searchResult.setMessageId(messageId);
                    searchResult.setReceiveTime(receiveTime);
                    searchResult.setEbxmlMessageStatus(ebxmlMessageStatusValue);
                    searchResult.setBsiMessageStatus(bsiMessssageStatusValue);
                    searchResultList.add(searchResult);
                }
                ++i;
            }
            return searchResultList;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public List searchFailReceiveMessagesByPeriod(long startTime, long endTime, int pageCount) throws MoniterPersistantException {
        try {
            ArrayList<SearchResult> searchResultList = new ArrayList<SearchResult>();
            MessageIdAndDocumentIdDAO messageIdAndDocumentIdDAO = new MessageIdAndDocumentIdDAO();
            IncomingMessageDAO incomingMessageDAO = new IncomingMessageDAO();
            MessageStatusDAO messageStatusDAO = new MessageStatusDAO();
            BsiMessageStatusDAO bsiMessageStatusDAO = new BsiMessageStatusDAO();
            List inComingMessageInfoList = incomingMessageDAO.getInComingMessagesByPeriod(startTime, endTime, pageCount);
            int inComingMessageInfoSize = inComingMessageInfoList.size();
            int i = 0;
            while (i < inComingMessageInfoSize) {
                InComingMessage inComingMessage = (InComingMessage)inComingMessageInfoList.get(i);
                if (inComingMessage != null) {
                    String messageId = inComingMessage.getMessageId();
                    String documentId = messageIdAndDocumentIdDAO.getDocumentIdByMessageId(messageId);
                    MessageStatus messageStatus = messageStatusDAO.getMessageStatus(messageId);
                    BsiMessageStatus bsiMessageStatus = bsiMessageStatusDAO.getBsiMessageStatus(messageId);
                    Timestamp receiveTime = inComingMessage.getReceiveTime();
                    int ebxmlMessageStatusValue = MessageStatusConstraints.Unknown;
                    int bsiMessageStatusValue = BsiMessageStatusConstraints.Unknown;
                    if (messageStatus != null) {
                        ebxmlMessageStatusValue = messageStatus.getStatus();
                    }
                    if (bsiMessageStatus != null) {
                        bsiMessageStatusValue = bsiMessageStatus.getStatus();
                    }
                    if (ebxmlMessageStatusValue == MessageStatusConstraints.Unknown || ebxmlMessageStatusValue == MessageStatusConstraints.Fail || bsiMessageStatusValue == BsiMessageStatusConstraints.Unknown || bsiMessageStatusValue == BsiMessageStatusConstraints.Fail) {
                        SearchResult searchResult = new SearchResult();
                        searchResult.setDocumentId(documentId);
                        searchResult.setMessageId(messageId);
                        searchResult.setReceiveTime(receiveTime);
                        searchResult.setEbxmlMessageStatus(ebxmlMessageStatusValue);
                        searchResult.setBsiMessageStatus(bsiMessageStatusValue);
                        searchResultList.add(searchResult);
                    }
                }
                ++i;
            }
            return searchResultList;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public long searchReceiveMessageCountByPeriod(long startTime, long endTime) throws MoniterPersistantException {
        try {
            IncomingMessageDAO incomingMessageDAO = new IncomingMessageDAO();
            return incomingMessageDAO.getInComingMessageCountByPeriod(startTime, endTime);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public int searchReceiveMessageCountByDocumentId(String documentId) throws MoniterPersistantException {
        try {
            MessageIdAndDocumentIdDAO messageIdAndDocumentIdDAO = new MessageIdAndDocumentIdDAO();
            return messageIdAndDocumentIdDAO.getMessageIdCountByDocumentId(documentId);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public List searchSendMessageByMessageId(String messageId) throws MoniterPersistantException {
        try {
            ArrayList<SendSearchResult> sendMessages = new ArrayList<SendSearchResult>();
            List outgoingMessages = new OutgoingMessageDAO().getOutgoingMessagesByMessageId(messageId);
            int i = 0;
            while (i < outgoingMessages.size()) {
                SendSearchResult sendSearchResult = new SendSearchResult();
                OutgoingMessage outgoingMessage = (OutgoingMessage)outgoingMessages.get(i);
                sendSearchResult.setMessageId(outgoingMessage.getMessageId());
                sendSearchResult.setRefToMessageId(outgoingMessage.getRefToMessageId());
                sendSearchResult.setSendTime(outgoingMessage.getSendTime());
                sendSearchResult.setStatus(outgoingMessage.getStatus());
                sendSearchResult.setMSGFilePath(outgoingMessage.getMSGFilePath());
                sendMessages.add(sendSearchResult);
                ++i;
            }
            return sendMessages;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public long searchSendMessageCountByMessageId(String messageId) throws MoniterPersistantException {
        try {
            OutgoingMessageDAO outgoingMessageDAO = new OutgoingMessageDAO();
            return outgoingMessageDAO.getOutgoingMessageCountByRefToMessageId(messageId);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public List searchSendMessageByRefToMessageId(String refToMessageId) throws MoniterPersistantException {
        try {
            ArrayList<SendSearchResult> sendMessages = new ArrayList<SendSearchResult>();
            List outgoingMessages = new OutgoingMessageDAO().getOutgoingMessagesByRefToMessageId(refToMessageId);
            int i = 0;
            while (i < outgoingMessages.size()) {
                SendSearchResult sendSearchResult = new SendSearchResult();
                OutgoingMessage outgoingMessage = (OutgoingMessage)outgoingMessages.get(i);
                sendSearchResult.setMessageId(outgoingMessage.getMessageId());
                sendSearchResult.setRefToMessageId(outgoingMessage.getRefToMessageId());
                sendSearchResult.setSendTime(outgoingMessage.getSendTime());
                sendSearchResult.setStatus(outgoingMessage.getStatus());
                sendSearchResult.setMSGFilePath(outgoingMessage.getMSGFilePath());
                sendMessages.add(sendSearchResult);
                ++i;
            }
            return sendMessages;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public long searchSendMessageCountByRefToMessageId(String refToMessageId) throws MoniterPersistantException {
        try {
            OutgoingMessageDAO outgoingMessageDAO = new OutgoingMessageDAO();
            return outgoingMessageDAO.getOutgoingMessageCountByRefToMessageId(refToMessageId);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public List searchSendMessageByPeriod(long startTime, long endTime, int pageCount) throws MoniterPersistantException {
        try {
            ArrayList<SendSearchResult> sendMessages = new ArrayList<SendSearchResult>();
            List outgoingMessages = new OutgoingMessageDAO().getOutgoingMessagesByPeriod(startTime, endTime, pageCount);
            int i = 0;
            while (i < outgoingMessages.size()) {
                SendSearchResult sendSearchResult = new SendSearchResult();
                OutgoingMessage outgoingMessage = (OutgoingMessage)outgoingMessages.get(i);
                sendSearchResult.setMessageId(outgoingMessage.getMessageId());
                sendSearchResult.setRefToMessageId(outgoingMessage.getRefToMessageId());
                sendSearchResult.setSendTime(outgoingMessage.getSendTime());
                sendSearchResult.setStatus(outgoingMessage.getStatus());
                sendSearchResult.setMSGFilePath(outgoingMessage.getMSGFilePath());
                sendMessages.add(sendSearchResult);
                ++i;
            }
            return sendMessages;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public long searchSendMessageCountByPeriod(long startTime, long endTime) throws MoniterPersistantException {
        try {
            OutgoingMessageDAO outgoingMessageDAO = new OutgoingMessageDAO();
            return outgoingMessageDAO.getOutgoingMessageCountByPeriod(startTime, endTime);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public boolean authorizeAdmin(String id, String password) throws MoniterPersistantException {
        try {
            AdminDAO adminDAO = new AdminDAO();
            return adminDAO.authorizeAdmin(id, password);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public void updateAdminPassword(String id, String password) throws MoniterPersistantException {
        try {
            AdminDAO adminDAO = new AdminDAO();
            adminDAO.updateAdminPassword(id, password);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public void deleteDocumentIdInfo(String action) throws MoniterPersistantException {
        try {
            DocumentIdInfoDAO documentIdInfoDAO = new DocumentIdInfoDAO();
            documentIdInfoDAO.deleteDocumentIdInfo(action);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public void insertDocumentIdInfo(String action, int payloadIndex, String xPath) throws MoniterPersistantException {
        try {
            DocumentIdInfoDAO documentIdInfoDAO = new DocumentIdInfoDAO();
            documentIdInfoDAO.insertDocumentIdInfo(action, payloadIndex, xPath);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public void updateDocumentIdInfo(String action, int payloadIndex, String xPath) throws MoniterPersistantException {
        try {
            DocumentIdInfoDAO documentIdInfoDAO = new DocumentIdInfoDAO();
            documentIdInfoDAO.updateDocumentIdInfo(action, payloadIndex, xPath);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public List getTrackers(String messageId) throws MoniterPersistantException {
        try {
            TrackerDAO trackerDAO = new TrackerDAO();
            return trackerDAO.getTrackers(messageId);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public MessageStore getMessageStoreMessage(String messageId) throws MoniterPersistantException {
        try {
            MessageStoreDAO messageStoreDAO = new MessageStoreDAO();
            return messageStoreDAO.getMessageStoreMessage(messageId);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public DocumentIdInfo getDocumentIdInfoByAction(String action) throws MoniterPersistantException {
        try {
            DocumentIdInfoDAO documentIdInfoDAO = new DocumentIdInfoDAO();
            return documentIdInfoDAO.getDocumentIdInfoByAction(action);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public List getDocumentIdInfos() throws MoniterPersistantException {
        try {
            DocumentIdInfoDAO documentIdInfoDAO = new DocumentIdInfoDAO();
            return documentIdInfoDAO.getDocumentIdInfos();
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public InComingMessage getInComingMessage(String messageId) throws MoniterPersistantException {
        try {
            IncomingMessageDAO incomingMessageDAO = new IncomingMessageDAO();
            return incomingMessageDAO.getInComingMessage(messageId);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public MessageStatus getMessageStatus(String messageId) throws MoniterPersistantException {
        try {
            return new MessageStatusDAO().getMessageStatus(messageId);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    public List searchFailBsiMessages() throws MoniterPersistantException {
        try {
            BsiMessageStatusDAO bsiMessageStatusDAO = new BsiMessageStatusDAO();
            return bsiMessageStatusDAO.getBsiMessagesByStatusCode(BsiMessageStatusConstraints.Fail);
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }
}

