/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.moniter.persistant;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.moniter.persistant.DbTemplate;
import org.kldp.ebmsh.moniter.persistant.DbWorker;
import org.kldp.ebmsh.moniter.persistant.MoniterPersistantException;
import org.kldp.ebmsh.moniter.persistant.OutgoingMessage;

public class OutgoingMessageDAO {
    List getOutgoingMessagesByMessageId(String messageId) throws MoniterPersistantException {
        try {
            List outgoingMessages = null;
            DbTemplate dbTemplate = new DbTemplate();
            final String queryStr = "select * from " + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage where MessageId=?";
            final Object[] params = new Object[]{messageId};
            outgoingMessages = (List)dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws MoniterPersistantException {
                    QueryRunner runner = new QueryRunner();
                    BeanListHandler resultSetHandler = new BeanListHandler(OutgoingMessage.class);
                    List queryResult = null;
                    try {
                        queryResult = (List)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                    }
                    catch (SQLException e) {
                        throw new MoniterPersistantException(0, e.getErrorCode(), e);
                    }
                    return queryResult;
                }
            });
            return outgoingMessages;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    long getOutgoingMessageCountByMessageId(String messageId) throws MoniterPersistantException {
        try {
            long outgoingMessageCount = 0L;
            BigDecimal outgoingMessageCountBigDecimal = null;
            DbTemplate dbTemplate = new DbTemplate();
            final Object[] params = new Object[]{messageId};
            final String queryStr = "select count(*) from " + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage where MessageId = ?";
            outgoingMessageCountBigDecimal = (BigDecimal)dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws MoniterPersistantException {
                    QueryRunner runner = new QueryRunner();
                    ScalarHandler resultSetHandler = new ScalarHandler();
                    BigDecimal queryResult = null;
                    try {
                        queryResult = (BigDecimal)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                    }
                    catch (SQLException e) {
                        throw new MoniterPersistantException(0, e.getErrorCode(), e);
                    }
                    return queryResult;
                }
            });
            if (outgoingMessageCountBigDecimal != null) {
                outgoingMessageCount = outgoingMessageCountBigDecimal.longValue();
            }
            return outgoingMessageCount;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    List getOutgoingMessagesByRefToMessageId(String refToMessageId) throws MoniterPersistantException {
        try {
            List outgoingMessages = null;
            DbTemplate dbTemplate = new DbTemplate();
            final String queryStr = "select * from " + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage where RefToMessageId=?";
            final Object[] params = new Object[]{refToMessageId};
            outgoingMessages = (List)dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws MoniterPersistantException {
                    QueryRunner runner = new QueryRunner();
                    BeanListHandler resultSetHandler = new BeanListHandler(OutgoingMessage.class);
                    List queryResult = null;
                    try {
                        queryResult = (List)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                    }
                    catch (SQLException e) {
                        throw new MoniterPersistantException(0, e.getErrorCode(), e);
                    }
                    return queryResult;
                }
            });
            return outgoingMessages;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    long getOutgoingMessageCountByRefToMessageId(String refToMessageId) throws MoniterPersistantException {
        try {
            long outgoingMessageCount = 0L;
            BigDecimal outgoingMessageCountBigDecimal = null;
            DbTemplate dbTemplate = new DbTemplate();
            final Object[] params = new Object[]{refToMessageId};
            final String queryStr = "select count(*) from " + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage where RefToMessageId = ?";
            outgoingMessageCountBigDecimal = (BigDecimal)dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws MoniterPersistantException {
                    QueryRunner runner = new QueryRunner();
                    ScalarHandler resultSetHandler = new ScalarHandler();
                    BigDecimal queryResult = null;
                    try {
                        queryResult = (BigDecimal)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                    }
                    catch (SQLException e) {
                        throw new MoniterPersistantException(0, e.getErrorCode(), e);
                    }
                    return queryResult;
                }
            });
            if (outgoingMessageCountBigDecimal != null) {
                outgoingMessageCount = outgoingMessageCountBigDecimal.longValue();
            }
            return outgoingMessageCount;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    List getOutgoingMessagesByPeriod(long startTime, long endTime, int pageCount) throws MoniterPersistantException {
        try {
            int perPageContentCount = 10;
            List outgoingMessageList = null;
            DbTemplate dbTemplate = new DbTemplate();
            int startCount = pageCount * perPageContentCount - 9;
            int endCount = startCount + 10;
            final Object[] params = new Object[]{new Timestamp(startTime), new Timestamp(endTime), new Integer(startCount), new Integer(endCount)};
            final String queryStr = "select * from (select /*+ index_desc(" + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage idx_" + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage) */ rownum as numrow, " + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage.* from " + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage where " + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage.SendTime >= ? and " + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage.SendTime <= ?" + ") where numrow >= ? and numrow < ?";
            outgoingMessageList = (List)dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws MoniterPersistantException {
                    QueryRunner runner = new QueryRunner();
                    BeanListHandler resultSetHandler = new BeanListHandler(OutgoingMessage.class);
                    List queryResult = null;
                    try {
                        queryResult = (List)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                    }
                    catch (SQLException e) {
                        throw new MoniterPersistantException(0, e.getErrorCode(), e);
                    }
                    return queryResult;
                }
            });
            return outgoingMessageList;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    long getOutgoingMessageCountByPeriod(long startTime, long endTime) throws MoniterPersistantException {
        try {
            long outgoingMessageCount = 0L;
            BigDecimal outgoingMessageCountBigDecimal = null;
            DbTemplate dbTemplate = new DbTemplate();
            final Object[] params = new Object[]{new Timestamp(startTime), new Timestamp(endTime)};
            final String queryStr = "select count(*) from " + EbmsConstants.bizboxDatabaseHeaderName + "OutgoingMessage where SendTime >= ? and SendTime <= ?";
            outgoingMessageCountBigDecimal = (BigDecimal)dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws MoniterPersistantException {
                    QueryRunner runner = new QueryRunner();
                    ScalarHandler resultSetHandler = new ScalarHandler();
                    BigDecimal queryResult = null;
                    try {
                        queryResult = (BigDecimal)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                    }
                    catch (SQLException e) {
                        throw new MoniterPersistantException(0, e.getErrorCode(), e);
                    }
                    return queryResult;
                }
            });
            if (outgoingMessageCountBigDecimal != null) {
                outgoingMessageCount = outgoingMessageCountBigDecimal.longValue();
            }
            return outgoingMessageCount;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }
}

