/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.bi.environment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.bi.environment.EbbiProperties;
import org.kldp.util.io.FileIoUtil;
import org.kldp.util.log.LogUtil;

public class EbbiConstants {
    private static final Log log = LogFactory.getLog(EbbiConstants.class);
    public static String queueConnectionFactoryName;
    public static String queueJNDIHeaderName;
    public static String applicationResultQueueName;
    public static String trackerQueueName;
    public static String dataSourceName;
    public static int duplicateErrorCode;
    public static String databaseType;
    public static String bizboxDatabaseHeaderName;

    static {
        log.info((Object)"BusinessLogic \uc124\uc815 \ud30c\uc77c\uc744 \ub85c\ub4dc \ud569\ub2c8\ub2e4.");
        String jeusHomeDirectory = System.getProperty("user.dir");
        String ebmsDirectory = FileIoUtil.fileSeparatorAddOrNone((String)(String.valueOf(jeusHomeDirectory) + File.separator + "webhome" + File.separator + "deploy_home" + File.separator + "EbmsEngine"));
        String ebmsConfigPath = String.valueOf(ebmsDirectory) + "config" + File.separator + "ebmsConfig.properties";
        log.info((Object)("BusinessLogic \uc124\uc815 \ud30c\uc77c \uacbd\ub85c: " + ebmsConfigPath));
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(ebmsConfigPath));
            EbbiProperties ebbiProperties = new EbbiProperties(properties);
            dataSourceName = ebbiProperties.getDataSourceName();
            log.info((Object)("dataSourceName -> " + dataSourceName));
            queueConnectionFactoryName = ebbiProperties.getQueueConnectionFactoryName();
            log.info((Object)("queueConnectionFactoryName -> " + queueConnectionFactoryName));
            queueJNDIHeaderName = ebbiProperties.getQueueJNDIHeaderName();
            log.info((Object)("queueJNDIHeaderName -> " + queueJNDIHeaderName));
            trackerQueueName = ebbiProperties.getTrackerQueueName();
            log.info((Object)("trackerQueueName -> " + trackerQueueName));
            applicationResultQueueName = ebbiProperties.getApplicationResultQueueName();
            log.info((Object)("applicationResultQueueName -> " + trackerQueueName));
            databaseType = ebbiProperties.getDatabaseType();
            if (databaseType.equals("mysql")) {
                duplicateErrorCode = 1062;
            } else if (databaseType.equals("oracle")) {
                duplicateErrorCode = 1;
            }
            log.info((Object)("databaseType -> " + databaseType));
            log.info((Object)("duplicateErrorCode -> " + duplicateErrorCode));
            bizboxDatabaseHeaderName = ebbiProperties.getBizboxDatabaseHeaderName();
            log.info((Object)("bizboxDatabaseHeaderName -> " + bizboxDatabaseHeaderName));
        }
        catch (IOException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
    }
}

