/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.bi.persistant;

import java.util.Date;
import org.kldp.ebmsh.bi.environment.EbbiConstants;
import org.kldp.ebmsh.bi.persistant.BiMessageStatusDAO;
import org.kldp.ebmsh.bi.persistant.BiPersistantException;
import org.kldp.ebmsh.bi.persistant.DocumentIdInfo;
import org.kldp.ebmsh.bi.persistant.DocumentIdInfoDAO;
import org.kldp.ebmsh.bi.persistant.MessageIdAndDocumentIdDAO;
import org.kldp.ebmsh.bi.persistant.TrackerDAO;

public class BiDatabaseManager {
    public void saveMessageStatus(String messageId, int status, String statusDesc) throws BiPersistantException {
        BiMessageStatusDAO bsiMessageStatusDAO = new BiMessageStatusDAO();
        try {
            bsiMessageStatusDAO.insertMessageStatus(messageId, status, statusDesc);
        }
        catch (BiPersistantException e) {
            if (e.getErrorCode() == EbbiConstants.duplicateErrorCode) {
                bsiMessageStatusDAO.updateMessageStatus(messageId, status, statusDesc);
            }
            throw e;
        }
    }

    public DocumentIdInfo getDocumentIdInfoByAction(String action) throws BiPersistantException {
        DocumentIdInfoDAO documentIdInfoDAO = new DocumentIdInfoDAO();
        return documentIdInfoDAO.getDocumentIdInfoByAction(action);
    }

    public void saveMessageIdAndDocumentId(String messageId, String documentId) throws BiPersistantException {
        MessageIdAndDocumentIdDAO messageIdAndDocumentIdDAO = new MessageIdAndDocumentIdDAO();
        try {
            messageIdAndDocumentIdDAO.insertMessageIdAndDocumentId(messageId, documentId);
        }
        catch (BiPersistantException ex) {
            if (ex.getErrorCode() == EbbiConstants.duplicateErrorCode) {
                messageIdAndDocumentIdDAO.updateMessageIdAndDocumentId(messageId, documentId);
            }
            throw ex;
        }
    }

    public void insertTrackerDetail(String messageId, String state, String information) throws BiPersistantException {
        TrackerDAO trackerDAO = new TrackerDAO();
        trackerDAO.insertTracker(messageId, new Date().getTime(), state, information);
    }
}

