/* ================================================================
 * EnhancedPreferences API - Alternative preferences package
 * ================================================================
 * 
 * Project Info:  http://development.poopu.com/ehprefs
 * Project Lead:  Justin Kim(jst.kim@gmail.com)
 * Create Date : 2004. 11. 17
 *
 * (C) Copyright 2004, by Justin Kim
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.poopu.util.prefs.hibernate.impl;

import java.sql.Connection;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.poopu.util.prefs.hibernate.HibernateManager;

/**
 * @author jskim
 *
 */
public class HibernateManagerImpl implements HibernateManager
{
  private static SessionFactory sessionFactory;
  
  private static Log log = LogFactory.getLog(HibernateManagerImpl.class);
  
//  static
//  {
//    try
//    {
//      sessionFactory = new Configuration().configure().buildSessionFactory();
//      log.trace("Build hibernate session factory successful.");
//    }
//    catch (HibernateException e)
//    {
//      new InternalError("Can't load hibernate configuration file.");
//    }
//  }
  
  public HibernateManagerImpl()
  {
    
  }

  /* (non-Javadoc)
   * @see com.poopu.util.prefs.hibernate.HibernateManager#getSessionFactory()
   */
  public SessionFactory getSessionFactory() throws HibernateException
  {
    if (sessionFactory == null)
    {
      sessionFactory = new Configuration().configure().buildSessionFactory();
    }
    return sessionFactory;
  }

  /* (non-Javadoc)
   * @see com.poopu.util.prefs.hibernate.HibernateManager#openSession()
   */
  public Session openSession() throws HibernateException
  {
    return getSessionFactory().openSession();
  }

  public Session openSession(Connection con) throws HibernateException
  {
    return getSessionFactory().openSession(con);
  }
}
