/* ================================================================
 * EnhancedPreferences API - Alternative preferences package
 * ================================================================
 * 
 * Project Info:  http://development.poopu.com/ehprefs
 * Project Lead:  Justin Kim(jst.kim@gmail.com)
 * Create Date : 2004. 11. 3
 *
 * (C) Copyright 2004, by Justin Kim
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.poopu.util.prefs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.prefs.Preferences;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.DefaultPicoContainer;

import com.poopu.util.prefs.EnhancedPreferencesFactory;
import com.poopu.util.prefs.PreferencesProvider;

/**
 * @author jskim
 *
 */
public class PreferencesProviderImpl implements PreferencesProvider
{
  private final static Log log = LogFactory.getLog(PreferencesProviderImpl.class);

  private static Properties props = new Properties();
  
  private static boolean loadFlag = false;
  
  static Preferences userRoot;
  
  static Preferences systemRoot;
  
  /**
   * 
   *
   */
  public PreferencesProviderImpl()
  {
    super();
    log.trace("Creating " + PreferencesProviderImpl.class + ".");
    if (!loadFlag)
      props = loadProperties();    
  }

  private Properties loadProperties()
  {
    log.trace("Loading EnhancedPreferences properties file.");
    
    String propertiesFile = System.getProperty(
        EnhancedPreferencesFactory.EH_PREFS_PROPERTIES,
        EnhancedPreferencesFactory.EH_PREFS_PROPERTIES);
    
    InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFile);
    try
    {
      props.load(is);
      loadFlag = true;
    }
    catch (IOException e)
    {
      log.warn("Can't load properties.", e);
    }

    return props;
  }
  
  private Preferences getPreferences(Class clazz, Integer nodeType)
  {
    MutablePicoContainer pico = new DefaultPicoContainer();
    Parameter[] param = {new ConstantParameter(nodeType)};
    pico.registerComponentImplementation(clazz, clazz, param);
    log.debug("creating Preferences Object : " + clazz.getName());
    Preferences prefs = (Preferences) pico.getComponentInstance(clazz);
    
    return prefs;
  }

  /* (non-Javadoc)
   * @see com.poopu.util.prefs.PreferencesProvider#getSystemRoot()
   */
  public Preferences getSystemRoot()
  {
    if (systemRoot == null)
    {
      log.debug("creating systemRoot prefs instance.");
      try
      {
        Class clazz = Class.forName(props.getProperty("systemPreferences.class"));        
        systemRoot = getPreferences(clazz, EnhancedPreferencesFactory.SYSTEM_NODE);
      }
      catch (Throwable t)
      {
        log.warn("Can't get systemRoot instance.", t);
      }
    }
    
    return systemRoot;
  }
  
  /* (non-Javadoc)
   * @see com.poopu.util.prefs.PreferencesProvider#getUserRoot()
   */
  public Preferences getUserRoot()
  {
    if (userRoot == null)
    {
      log.debug("creating userRoot prefs instance.");
      try
      {
        Class clazz = Class.forName(props.getProperty("userPreferences.class"));        
        userRoot = getPreferences(clazz, EnhancedPreferencesFactory.USER_NODE);
      }
      catch (Throwable t)
      {
        log.warn("Can't get userRoot instance.", t);
      }
    }
 
    return userRoot;
  }
  
  
  /* (non-Javadoc)
   * @see com.poopu.util.prefs.PreferencesProvider#getProperties()
   */
  public Properties getProperties()
  {
    if (!loadFlag)
      loadProperties();
    
    return props;
  }
}