/* ================================================================
 * EnhancedPreferences API - Alternative preferences package
 * ================================================================
 * 
 * Project Info:  http://development.poopu.com/ehprefs
 * Project Lead:  Justin Kim(jst.kim@gmail.com)
 * Create Date : 2004. 11. 3
 *
 * (C) Copyright 2004, by Justin Kim
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.poopu.util.prefs.om;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * @author jskim
 * @hibernate.cache usage="transactional"
 * @hibernate.class table="EHPREFS_NODE"
 */
public class Node implements Serializable, Cloneable
{

  private Long id;

  private Long parentId;

  private String absolutePath;

  private String name;

  private Integer type;

  private Date creationDate;

  private Date modifiedDate;

  private Set properties = new HashSet();

  /**
   * 
   */
  public Node()
  {
    super();
    // TODO Auto-generated constructor stub
  }

  /**
   * @return Returns the absolutePath.
   * @hibernate.property column="fullpath" not-null="true"
   */
  public String getAbsolutePath()
  {
    return absolutePath;
  }

  /**
   * @return Returns the creationDate.
   * @hibernate.property column="creation_date" not-null="true"
   */
  public Date getCreationDate()
  {
    return creationDate;
  }

  /**
   * @return Returns the id.
   * @hibernate.id generator-class="net.sf.hibernate.id.SequenceHiLoGenerator"
   * @hibernate.generator-param name="sequence" value="ehprefs_node_seq"
   */
  public Long getId()
  {
    return id;
  }

  /**
   * @return Returns the modifiedDate.
   * @hibernate.property column="modified_date" not-null="true"
   */
  public Date getModifiedDate()
  {
    return modifiedDate;
  }

  /**
   * @return Returns the name.
   * @hibernate.property column="name" not-null="true"
   */
  public String getName()
  {
    return name;
  }

  /**
   * @return Returns the parentId.
   * @hibernate.property column="parent_id"
   */
  public Long getParentId()
  {
    return parentId;
  }

  /**
   * @return Returns the type.
   * @hibernate.property column="type" not-null="true"
   */
  public Integer getType()
  {
    return type;
  }

  /**
   * @return Returns the properties.
   * @hibernate.set name="properties" inverse="true" lazy="true" cascade="all-delete-orphan"
   * @hibernate.collection-key column="node_id"
   * @hibernate.collection-one-to-many class="com.poopu.util.prefs.om.Property"
   */
  public Set getProperties()
  {
    return properties;
  }

  /**
   * @param properties The properties to set.
   */
  public void setProperties(Set properties)
  {
    this.properties = properties;
  }

  /**
   * @param absolutePath The absolutePath to set.
   */
  public void setAbsolutePath(String absolutePath)
  {
    this.absolutePath = absolutePath;
  }

  /**
   * @param creationDate The creationDate to set.
   */
  public void setCreationDate(Date creationDate)
  {
    this.creationDate = creationDate;
  }

  /**
   * @param id The id to set.
   */
  public void setId(Long id)
  {
    this.id = id;
  }

  /**
   * @param modifiedDate The modifiedDate to set.
   */
  public void setModifiedDate(Date modifiedDate)
  {
    this.modifiedDate = modifiedDate;
  }

  /**
   * @param name The name to set.
   */
  public void setName(String name)
  {
    this.name = name;
  }

  /**
   * @param parentId The parentId to set.
   */
  public void setParentId(Long parentId)
  {
    this.parentId = parentId;
  }

  /**
   * @param type The type to set.
   */
  public void setType(Integer type)
  {
    this.type = type;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#clone()
   */
  public Object clone() throws CloneNotSupportedException
  {
    Node returnObj = new Node();

    if (this.id != null)
      returnObj.setId(new Long(this.id.longValue()));

    if (this.parentId != null)
      returnObj.setParentId(new Long(this.parentId.longValue()));

    if (this.absolutePath != null)
      returnObj.setAbsolutePath(new String(this.absolutePath));

    if (this.name != null)
      returnObj.setName(new String(name));

    if (this.type != null)
      returnObj.setType(new Integer(this.type.intValue()));

    if (this.creationDate != null)
      returnObj.setCreationDate((Date) this.creationDate.clone());

    if (this.modifiedDate != null)
      returnObj.setModifiedDate((Date) this.creationDate.clone());

    return returnObj;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  public boolean equals(Object obj)
  {
    boolean ret = false;

    if (obj instanceof Node)
    {
      Node targetObj = (Node) obj;

      if (targetObj.getAbsolutePath().equals(this.absolutePath)
          && targetObj.getName().equals(this.name))
      {
        ret = true;
      }
    }

    return ret;
  }
}

