/* ================================================================
 * EnhancedPreferences API - Alternative preferences package
 * ================================================================
 * 
 * Project Info:  http://development.poopu.com/ehprefs
 * Project Lead:  Justin Kim(jst.kim@gmail.com)
 * Create Date : 2004. 11. 3
 *
 * (C) Copyright 2004, by Justin Kim
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.poopu.util.prefs.om;

import java.io.Serializable;
import java.util.Date;

/**
 * @author jskim
 * @hibernate.cache usage="transactional"
 * @hibernate.class table="EHPREFS_PROPERTY"
 */
public class Property implements Serializable, Cloneable
{
  private Long id;

  private Long nodeId;

  private String key;

  private String value;

  private Date creationDate;

  private Date modifiedDate;

  /**
   * 
   */
  public Property()
  {
    super();
  }

  /**
   * @return Returns the creationDate.
   * @hibernate.property column="creation_date" not-null="true"
   */
  public Date getCreationDate()
  {
    return creationDate;
  }

  /**
   * @return Returns the id.
   * @hibernate.id generator-class="net.sf.hibernate.id.SequenceHiLoGenerator"
   * @hibernate.generator-param name="sequence" value="ehprefs_property_seq"
   */
  public Long getId()
  {
    return id;
  }

  /**
   * @return Returns the key.
   * @hibernate.property column="property_key" not-null="true"
   */
  public String getKey()
  {
    return key;
  }

  /**
   * @return Returns the modifiedDate.
   * @hibernate.property column="modified_date" not-null="true"
   */
  public Date getModifiedDate()
  {
    return modifiedDate;
  }

  /**
   * @return Returns the nodeId.
   * @hibernate.property column="node_id" not-null="true"
   */
  public Long getNodeId()
  {
    return nodeId;
  }

  /**
   * @return Returns the value.
   * @hibernate.property column="property_value" not-null="true"
   */
  public String getValue()
  {
    return value;
  }

  /**
   * @param creationDate The creationDate to set.
   */
  public void setCreationDate(Date creationDate)
  {
    this.creationDate = creationDate;
  }

  /**
   * @param id The id to set.
   */
  public void setId(Long id)
  {
    this.id = id;
  }

  /**
   * @param key The key to set.
   */
  public void setKey(String key)
  {
    this.key = key;
  }

  /**
   * @param modifiedDate The modifiedDate to set.
   */
  public void setModifiedDate(Date modifiedDate)
  {
    this.modifiedDate = modifiedDate;
  }

  /**
   * @param nodeId The nodeId to set.
   */
  public void setNodeId(Long nodeId)
  {
    this.nodeId = nodeId;
  }

  /**
   * @param value The value to set.
   */
  public void setValue(String value)
  {
    this.value = value;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#clone()
   */
  public Object clone() throws CloneNotSupportedException
  {
    Property returnObj = new Property();
    
    if (this.id != null)
      returnObj.setId(new Long(this.id.longValue()));
    
    if (this.nodeId != null)
      returnObj.setNodeId(new Long(this.nodeId.longValue()));
    
    if (this.key != null)
      returnObj.setKey(new String(this.key));
    
    if (this.value != null)
      returnObj.setValue(new String(this.value));
    
    if (this.creationDate != null)
      returnObj.setCreationDate((Date) this.creationDate.clone());
    
    if (this.modifiedDate != null)
      returnObj.setModifiedDate((Date) this.modifiedDate.clone());
        
    return returnObj;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  public boolean equals(Object obj)
  {
    boolean ret = false;
    if (obj instanceof Property)
    {
      Property targetObj = (Property) obj;

      if (targetObj.getNodeId().equals(this.nodeId)
          && targetObj.getKey().equals(this.key))
      {
        ret = true;
      }
    }
    return ret;
  }
}