/// @file GameCore.h
#ifndef GAMECORE_H
#define GAMECORE_H

#include "../state/StartState.h"

/**
	@brief ӿ ٽ Runner Ŭ

	ӿ ۵Ű ٽ Runner ŬԴϴ.\n
	  State Ŭ ĸȭ Ǿ,	 StartState Ŭ ̿մϴ.\n
	GameCoreClass run Լ  Ʈ() Ʈ ۵Ű ٽԼԴϴ.
*/
class GameCore {
	public:
		GameCore(LayerInfo* _pLayerInfo){
			pLayerInfo_ = _pLayerInfo;
		}
		~GameCore(){}

		/// @brief GameBaseRunnerſ Ǵ ӿ ٽԼ
		void run(){
			
			pState_ = new StartState;
			pState_->initState(pLayerInfo_);

			MSG msg;
			ZeroMemory( &msg, sizeof(msg) );
			while( msg.message != WM_QUIT ){
				if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) ){
					TranslateMessage( &msg );
					DispatchMessage( &msg );
				}else{
					pState_->cache();
					pState_->input();
					pState_->process();
					pState_->render();
					if(pLayerInfo_->bStateChanged){
						GameState* tmpState = pState_;
						pState_ = pState_->changeState();
						delete tmpState; tmpState = NULL;

						pState_->initState(pLayerInfo_);
					}
				}
			}
			delete pState_; pState_ = NULL;
		}

	private:
		GameCore(){}
		LayerInfo* pLayerInfo_;
		GameState* pState_;

};

#endif