#include "StartState.h"

void StartState::initState(LayerInfo* _pLayerInfo){
	pLayerInfo_ = _pLayerInfo;
	pLayerInfo_->bStateChanged = FALSE;

	pLayerInfo_->pD3DDevice->SetRenderState( D3DRS_LIGHTING, false);
	ShowCursor(false);
	TiXmlDocument xmlDoc;
	bool loadOkay = xmlDoc.LoadFile("stage.xml");
	if ( !loadOkay ){
		MessageBox(NULL, "XML not found", "Error Message", MB_OK | MB_ICONERROR);
		exit( 1 );
	}
	TiXmlHandle docHandle( &xmlDoc );
	TiXmlNode* pSceneNode = docHandle.Child( "scene", 0 ).Node();
	pMObjectSet_ = ObjectManager::load(pLayerInfo_, pSceneNode);
	pRenderMObjectArray_ = pMObjectSet_->pRenderMObject;
	pIndicatorArray_ = pMObjectSet_->pIndicator;
}
void StartState::cache(){
	if (!boolCache_){
		boolCache_ = TRUE;
	}
}
void StartState::input(){}

void StartState::process(){
	for(int a=0; a < pMObjectSet_->numIndicator; a++){
		if(pIndicatorArray_[a].bShow){
			int type = pIndicatorArray_[a].modelType;
			pRenderMObjectArray_[type].listMObject.push_back((pIndicatorArray_ + a));
		}
	}
			
}

GameState* StartState::changeState(){
	return this;
}
void StartState::render(){
	pLayerInfo_->pD3DDevice->Clear(0,NULL,D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,D3DCOLOR_XRGB(100,100,100),1.0f,0);
	pLayerInfo_->pD3DDevice->BeginScene();
	ObjectManager::camera(pLayerInfo_, 0, 0, 0);
	pLayerInfo_->pD3DDevice->SetFVF(D3DFVF_CustomVertex);
	for(int a=0; a<pMObjectSet_->numRenderMObject; a++){
        ObjectManager::show(pLayerInfo_, pMObjectSet_->pRenderMObject+a);
		pMObjectSet_->pRenderMObject[a].listMObject.clear();
	}
	pLayerInfo_->pD3DDevice->EndScene();
	pLayerInfo_->pD3DDevice->Present(NULL,NULL,NULL,NULL);
}
