/// @file GameCore.h
#ifndef GAMECORE_H
#define GAMECORE_H
#include "../graphic/CoreGraphic.h"
#include "../input/CoreInput.h"
#include "../sound/OggPlayer.h"
#include "RenderPocket.h"
#include "../../object/RenderQueueMaker.h"
#include "../../object/Indicator.h"
#include "../../object/PrintBoard.h"
#include "ControlTable.h"
#include <map>
#include <string>
using std::string;
using std::map;

/**
	@brief μ  Ŭ

	 μ Ѱϴ ŬԴϴ.\n
	ũ ε μ, Ʈ μ,  μ մϴ.\n
	 ü Ұ ɺ  ̳ʿ ϴ.\n
	⺻ ü RObjectPocket   ȿ  ̸ еִ RenderPocket ϴ.\n
	ü ⺻  ü մϴ.\n
	μ Ȳ ControlTable ü ϸ ü ⿡  Ȳ   ֽϴ.\n
	ũƮ command oper   ִ Լµ մϴ.
*/
class GameCore {
	public:
		GameCore(){
			makeRenderQueue_["cube"] = RenderQueueMaker::makeCubeQueue;
			makeRenderQueue_["sprite"] = RenderQueueMaker::makeSpriteQueue;

			makeRObject_["indicator"] = Indicator::makeIndicator;
			makeRObject_["print_board"] = PrintBoard::makePrintBoard;

			commandOper_["show"] = operShow_;
			commandOper_["rotate"] = operRotate_;
			commandOper_["print"] = operPrint_;
		}
		~GameCore(){
			aOggPlayer_.Close();
			clearScriptPocket_();
			clearMainPocket_();
		}
		void initGame(HWND _hWnd, int _width, int _height, bool _bWindowed);
		void run();

	private: //private member
		CoreGraphic aCoreGraphic_;
		CoreInput aCoreInput_;
		OggPlayer aOggPlayer_;

		TiXmlDocument xmlDoc_;

		map<string, RObject* (*)(TiXmlElement*)> makeRObject_;
		map<string, RenderQueue* (*)(RenderPocket&, TiXmlElement*)> makeRenderQueue_;
		map<string, void (GameCore::*)(TiXmlElement*)> commandOper_;
		//makeSObject °, SObject °  ֱ ̴.

		//ü ɶ ϴ ̳
		vector<RenderQueue*> mainRenderQueuePocket_;
		vector<RenderQueue*> scriptRenderQueuePocket_;
		vector<RenderQueue*> * pCurrentRenderQueuePocket_;
		vector<RenderQueue*>::iterator pItrRenderQueue_;

		//ü    ֵ   ϴ ̳
		RenderPocket aRenderPocket_;

		//ü Ȳ   ְϴ ControlTable
		ControlTable aControlTable_;

		// Ʈϴ ü
		vector<RObject*> mainRObjectPocket_;
		vector<RObject*> scriptRObjectPocket_;
		vector<RObject*> * pCurrentRObjectPocket_;
		vector<RObject*>::iterator pItrRObject_;
		TiXmlElement* pCommandElement_;
		string key_;

	private: //private member-fuction
		void putRenderPocket_(TiXmlElement* _pRenderElement);
		void putRObjectPocket_(TiXmlElement* _pRObjectElement);
		void controlScript_(TiXmlElement* _pScriptElement);
		inline void loadXmlFile_(const char* _fileName);
		inline void loadSceneObject_(int _sceneNum);
		//void loadScriptObject_(int _scriptNum);

		void clearMainPocket_();
		void clearScriptPocket_();

		//ũƮ command oper ϱ  Լ
		void operShow_(TiXmlElement* _pCommandElement);
		void operRotate_(TiXmlElement* _pCommandElement);
		void operPrint_(TiXmlElement* _pCommandElement);
};

#endif