/// @file GameCore.h
#ifndef GAMECORE_H
#define GAMECORE_H

#include "../object/ObjectManager.h"

class GameCore {
	public:
		GameCore(){}
		~GameCore(){
			aOggPlayer_.Close();
		}

		void initGame(HWND _hWnd, int _width, int _height, bool _bWindowed){
			if(!_bWindowed){SetWindowLong(_hWnd, GWL_STYLE, WS_OVERLAPPED);}
			aCoreGraphic_.initD3D(_hWnd, _width, _height, _bWindowed);
			aCoreInput_.initDInput(_hWnd);
			aOggPlayer_.InitDirectSound(_hWnd);
			aObjectManager_.initObjectManager(&aCoreGraphic_, &aCoreInput_, &aOggPlayer_);
		}

		/// @brief GameBaseRunnerſ Ǵ ӿ ٽԼ
		void run(){
			MSG msg;
			ZeroMemory( &msg, sizeof(msg) );
			while( msg.message != WM_QUIT ){
				if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) ){
					TranslateMessage( &msg );
					DispatchMessage( &msg );
				}else{
					aObjectManager_.tmpProcess();
					aObjectManager_.tmpRender();
				}
			}
		}

	private:
		ObjectManager aObjectManager_;
		CoreGraphic aCoreGraphic_;
		CoreInput aCoreInput_;
		OggPlayer aOggPlayer_;
};

#endif