/// @file CoreGraphic.h
#ifndef COREGRAPHIC_H
#define COREGRAPHIC_H

#include "RMObject.h"

/**
	@brief Direct3D Ŭ

	Graphic õ ġ ϰ   մϴ.
*/
class CoreGraphic {
	public:
		CoreGraphic(){
			pD3D_ = NULL;
			pD3DDevice_ = NULL;
		}
		~CoreGraphic(){
			if(pD3DDevice_ != NULL){ pD3DDevice_->Release(); pD3DDevice_ = NULL;}
			if(pD3D_ != NULL){ pD3D_->Release(); pD3D_ = NULL;}
		}

		void initD3D(const HWND _hWnd, const int _width, const int _height, const bool _windowed);
		void camera(const float _fX, const float _fY, const float _fZ);
		void show(RMObject* _pRMObject);
		LPDIRECT3DDEVICE9 getD3DDevice(){return pD3DDevice_;}

	private:
		LPDIRECT3D9           pD3D_;
		LPDIRECT3DDEVICE9     pD3DDevice_;

		D3DPRESENT_PARAMETERS aD3Dpp_;
		D3DDISPLAYMODE        aD3Ddm_;
		float monitorRatio_;
};

#endif