#ifndef GAMECORE_H
#define GAMECORE_H

#include "LayerInfo.h"

//for event actor
#define D3DFVF_CUSTOM (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_TEX1)
#define SUN   0
#define EARTH 1
#define MOON  2
#define BOX   3
#define COMET 4

//for input listener
#define MOUSE_LBUTTON	0
#define MOUSE_RBUTTON	1
#define MOUSE_MBUTTON	2

struct VertexCustom{
	FLOAT x, y, z;		//Position of vertex in 3D space
	FLOAT nx, ny, nz;	//Lighting Normal
	FLOAT tu, tv;		//Texture coordinates
};

class MemPool {
	public:
		MemPool(LayerInfo* _pLayerInfo);
		~MemPool();

		LPDIRECT3DDEVICE9 pD3DDevice;
		//for texture
		LPDIRECT3DTEXTURE9 pSunTexture;
		LPDIRECT3DTEXTURE9 pEarthTexture;
		LPDIRECT3DTEXTURE9 pMoonTexture;
		LPDIRECT3DTEXTURE9 pCometTexture;
		LPDIRECT3DTEXTURE9 pCubeTexture;
		
		//for shape, especially sphere
		LPDIRECT3DVERTEXBUFFER9 pSphereVertexBuffer;
		LPDIRECT3DINDEXBUFFER9 pSphereIndexBuffer;
		int numSphereVertex;
		int numShperePolygon;
		int numSphereIndex;
		//shape for cube
		LPDIRECT3DVERTEXBUFFER9 pCubeVertexBuffer;
		LPDIRECT3DINDEXBUFFER9 pCubeIndexBuffer;
		int numCubeVertex;
		int numCubePolygon;
		int numCubeIndex;

		//for lightMaterial
		D3DMATERIAL9 lightTexturedMaterial;
		D3DMATERIAL9 lightEmissiveMaterial;

	private:
		MemPool(){}
		bool createSphere(const int _rings, const int _segments);
		bool createCube(const float _width, const float _height, const float _depth);

};

class EventActor {
	public:
		EventActor():centerPosition_(0.0f,0.0f,0.0f){}

		void setActor(MemPool* _pMemPool, const int _type);
		void action();
		void show();
		D3DXMATRIXA16 getMatWorld(){return matWorld_;}

	private:
		LPDIRECT3DDEVICE9 pD3DDevice_;
		
		//for physics and location
		D3DXVECTOR3 centerPosition_;
		D3DXMATRIXA16 matWorld_;

		//for shape
		// 1. texture
		LPDIRECT3DTEXTURE9 pTexture_;
		D3DMATERIAL9* pLightMaterial_;
		// 2. vertex
		LPDIRECT3DVERTEXBUFFER9 pVertexBuffer_;
		LPDIRECT3DINDEXBUFFER9 pIndexBuffer_;
		int ActorType_;
		int numVertex_;
		int numPolygon_;
		int numIndex_;
};

class GameCore {
	public:
		GameCore(LayerInfo* _pLayerInfo);
		~GameCore(){}

		void setLight1();
		void Camera1();
		void Camera2();
		void InputListener();
		void run();

	private:
		GameCore(){}
		LayerInfo* pLayerInfo_;
		
		//for rolling camera
		LPDIRECT3DDEVICE9 pD3DDevice_;
        DIMOUSESTATE mouseState_;
		char keyBuffer_[256];
		EventActor someActors[4];
		
		float mouseLx_;
		float mouseLy_;
		float mouseRx_;
		float mouseRy_;
		float mouseZ_;
};

#endif