#ifndef WINDOWBASE_H
#define WINDOWBASE_H

#include "LayerInfo.h"
LRESULT CALLBACK MsgProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

class WindowBase {
	public:
		//set default
		WindowBase(LayerInfo* _pLayerInfo)
			:pClass_("class1"), pWindowCaption_("Window1"){

			pLayerInfo_ = _pLayerInfo;
			witdh_ = 640;
			height_ = 480;
						
			wc_.cbSize = sizeof(WNDCLASSEX);
			wc_.style = CS_CLASSDC;
			wc_.lpfnWndProc = MsgProc;
			wc_.cbClsExtra = 0L;
			wc_.cbWndExtra = 0L;
			wc_.hInstance = GetModuleHandle(NULL);
			wc_.hIcon = NULL;
			wc_.hCursor = NULL;
			wc_.hbrBackground = NULL;
			wc_.lpszMenuName = NULL;
			wc_.lpszClassName = pClass_;
			wc_.hIconSm = NULL;
		}
		~WindowBase(){}

		//set WindowBase
		void setClassName(char* _pClassName){pClass_ = _pClassName;}
		void setWindowSize(int _w, int _h){witdh_=_w; height_=_h;}
		void setWindowCaption(char* _pCaption){pWindowCaption_=_pCaption;}

		//new and delete window
		void newWindow(){
			RegisterClassEx( &wc_ );
			hWnd_ = CreateWindow( pClass_, pWindowCaption_, WS_OVERLAPPEDWINDOW,
                                 CW_USEDEFAULT, CW_USEDEFAULT, witdh_, height_,
                                 GetDesktopWindow(), NULL, wc_.hInstance, NULL );
			pLayerInfo_->hWnd = hWnd_;
			ShowWindow( hWnd_, SW_SHOWDEFAULT );
		}
		void deleteWindow(){UnregisterClass( pClass_, wc_.hInstance );}

		//default run
		void run(){
			MSG msg;
			while( GetMessage(&msg, 0, 0, 0) ){
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
		}
		
	private:
		WindowBase(){}

		int witdh_;
		int height_;
		char* pClass_;
		char* pWindowCaption_;
		WNDCLASSEX wc_;
		HWND hWnd_;
		LayerInfo* pLayerInfo_;
};

LRESULT CALLBACK MsgProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam){

	switch(msg){
		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;
	}
	return (DefWindowProc(hWnd, msg, wParam, lParam));
}

#endif