/// @file Actor.h
#ifndef ACTOR_H
#define ACTOR_H
#include "../../xml/tinyxml.h"
#include "DevicePocket.h"
#include "ControlTable.h"

/**
	@brief  action ü ߻Ŭ

	Ӽӿ ׼ ϴ Ӱü ActorŬ ӹ޽ϴ.\n
	client process/draw Լ ȣϸ  process/draw  ü մϴ.
*/
class Actor {
public:
	static void cmdShow(Actor* _pRObject){
		_pRObject->bShow = true;
	}
	static void cmdFocus(Actor* _pRObject){
		_pRObject->bFocus = true;
	}
public:
	Actor() : bShow(FALSE), bFocus(FALSE), fOpacity(1), fX(0), fY(0), fZ(0) {}
	virtual ~Actor(){}
	virtual void draw(Model* _pModel) = 0;
	virtual void process() = 0;
	virtual void setRObject(DevicePocket* _pDevicePocket, ControlTable* _pControlTable) = 0;
public:
	bool  bShow;
	bool  bFocus;
	float fOpacity;
	float fX;
	float fY;
	float fZ;
	D3DXMATRIXA16 matWorld; ///<   matڷ(Actor ⺻  ϴ)
	ControlTable* pControlTable; ///<   ControlTable
};
#endif