/// @file ScriptManager.h
#ifndef SCRIPTMANAGER_H
#define SCRIPTMANAGER_H
#include "ActionManager.h"
#include "RenderManager.h"
#include "SoundManager.h"
#include <map>
#include <deque>
#include <string>
using std::string;
using std::map;
using std::deque;
/**
	@brief  XML ũƮ Ŵ

	ũƮ  ü  ü Setting / Processing Ŵ
*/
class ScriptManager {
	//friend class
	friend class ManagerCommand;

public:
	ScriptManager();
	void initManager(ActionManager* _pActionManager, RenderManager* _pRenderManager);
	void process();
	void loadXmlFile_(const char* _fileName);
	void controlScript();

private:
	//for actor
	map<string, Actor* (*)(TiXmlElement*)> makeActor_;
	map<string, Actor* (*)(vector<Actor*>*, TiXmlElement*)> makeToolKit_;

	//for Render Resource
	map<string, RenderResource* (*)(RenderManager*, TiXmlElement*)> makeRenderResource_;

	//for command operation
	map<string, void (*)(Actor*)> actorCommand_;
	map<string, void (*)(ScriptManager*)> managerCommand_;

	//for load xmlfile
	TiXmlDocument xmlDoc_;
	
	//for loader key
	string key_;

	//Manager
	ActionManager* pActionManager_;
	RenderManager* pRenderManager_;
	SoundManager*  pSoundManager_;
	ControlTable* pControlTable_;

	bool bScriptWait_;
	TimePocket aScriptProcessTime_;

private: //private function
	void putActorPocket_(TiXmlElement* _pActorElement);
	void putRenderPocket_(TiXmlElement* _pRenderElement);
	void loadScene_(int _sceneNum);
	void loadScript_(TiXmlElement* _pScriptElement);
	void loadControlElement_(TiXmlElement* _pControlElement);
};
#endif