/// @file VerticalMenu.h
#ifndef VERTICALMENU_H
#define VERTICALMENU_H

#include "toolkit/FocusEventMove.h"
#include "toolkit/ActEventExit.h"
#include "toolkit/ActEventLoadControlElement.h"
#include <vector>
using std::vector;
/**
	@brief ޴ ̳

	 ޴  ִ ̳ Դϴ.
*/
class VerticalMenu : public ToolKit {
public:
	static Actor* makeVetricalMenu(vector<Actor*>* _pActorPocket, TiXmlElement* _pSelectListElement){
		VerticalMenu* pVerticalMenu = new VerticalMenu;
		_pSelectListElement->Attribute("row", &(pVerticalMenu->row));
		TiXmlElement* pActorElement = _pSelectListElement->FirstChildElement("actor");
		while(pActorElement){
			int robject; pActorElement->Attribute("robject", &robject);
			pVerticalMenu->actorPocket.push_back( (*(_pActorPocket))[robject] );
			pActorElement = pActorElement->NextSiblingElement("actor");
		}
		TiXmlElement* pEventElement = _pSelectListElement->FirstChildElement("event");
		while(pEventElement){
			//ToolKitEventLoader::putEvent(pEventElement, pVerticalMenu);
			ToolKitEvent* pToolKitEvent = new ToolKitEvent;
			TiXmlElement* pFocusElement = pEventElement->FirstChildElement("focus");
			if(strcmp(pFocusElement->Attribute("oper"), "move") == 0){
				int actor; pFocusElement->Attribute("actor", &actor);
				double x; pFocusElement->Attribute("x", &x);
				double y; pFocusElement->Attribute("y", &y);
				FocusEventMove* pFocusOperMove = new FocusEventMove;
				pFocusOperMove->setFocueEvnet(actor, x, y);
				pToolKitEvent->pFocusEvent = pFocusOperMove;
			}
			TiXmlElement* pActElement = pEventElement->FirstChildElement("act");
			if(strcmp(pActElement->Attribute("oper"), "control") == 0){
				ActEventLoadControlElement* pActOperControl = new ActEventLoadControlElement;
				pActOperControl->setActEvent(pActElement->FirstChildElement("control"));
				pToolKitEvent->pActEvent = pActOperControl;
			}else if(strcmp(pActElement->Attribute("oper"), "exit") == 0){
				ActEventExit* pActOperExit = new ActEventExit;
				pToolKitEvent->pActEvent = pActOperExit;
			}
			pVerticalMenu->toolKitEventPocket.push_back( pToolKitEvent );

			pEventElement = pEventElement->NextSiblingElement("event");
		}
		return (Actor*)pVerticalMenu;
	}
	VerticalMenu() :
		currentEvent_(0),
		bUpKeyState_(FALSE), bDownKeyState_(FALSE), bReturnKeyState_(FALSE) {}
	virtual ~VerticalMenu(){}
	void process(){
		if(bFocus){
			toolKitEventPocket[currentEvent_]->pFocusEvent->focus(this);
			if(pCoreInput_->clickedKey(DIK_UP, bUpKeyState_)){
				currentEvent_ = (currentEvent_ - 1 + row) % row;
			}
			if(pCoreInput_->clickedKey(DIK_DOWN, bDownKeyState_)){
				currentEvent_ = (currentEvent_ + 1) % row;
			}
			if(pCoreInput_->clickedKey(DIK_RETURN, bReturnKeyState_)){
				toolKitEventPocket[currentEvent_]->pActEvent->act(this);
			}
		}
	}
	void setRObject(DevicePocket* _pDevicePocket, ControlTable* _pControlTable){
		pCoreInput_ = &(_pDevicePocket->aCoreInput);
		pControlTable = _pControlTable;
	}
	void draw(Model* _pModel){}
	//row for setting Vertical Action
	int row;
private:
	bool bUpKeyState_;
	bool bDownKeyState_;
	bool bReturnKeyState_;
	int currentEvent_;
	CoreInput* pCoreInput_;
};
#endif