/// @file ToolKit.h
#ifndef TOOLKIT_H
#define TOOLKIT_H
#include "../core/process/Actor.h"
#include <vector>
using std::vector;

class ToolKit;
/**
	@brief Focus Evnet Interface

	ToolKit ü Focus Event  ߻ ϴ ̽
*/
class FocusEvent {
	public:
		FocusEvent(){}
		virtual ~FocusEvent(){}
		virtual void focus(ToolKit* _pToolKit) = 0;
};
/**
	@brief Act Evnet Interface

	ToolKit ü Act Event  ߻ ϴ ̽
*/
class ActEvent {
	public:
		ActEvent(){}
		virtual ~ActEvent(){}
		virtual void act(ToolKit* _pToolKit) = 0;
};
/**
	@brief ToolKit Evnet Interface

	ActEvent  FocusEvent ü  ̳ Ŭ \n
	̺Ʈ Command  ȣȴ.
*/
class ToolKitEvent {
	public:
		ToolKitEvent() : pFocusEvent(NULL), pActEvent(NULL) {}
		~ToolKitEvent(){
			if ( pFocusEvent != NULL ){ delete pFocusEvent; pFocusEvent = NULL; }
			if ( pActEvent != NULL ){ delete pActEvent; pActEvent = NULL; }
		}
		FocusEvent* pFocusEvent;
		ActEvent* pActEvent;
};

/**
	@brief ToolKit Interface

	̳ ActorŬ TookKit ߻ Ŭ(̽)
*/
class ToolKit : public Actor {
public:
	virtual ~ToolKit(){
		vector<ToolKitEvent*>::iterator itr;
		for(itr = toolKitEventPocket.begin(); itr != toolKitEventPocket.end(); itr++){
			delete *itr;
		}
	}
	vector<Actor*> actorPocket;
	vector<ToolKitEvent*> toolKitEventPocket;
};
#endif