/* core.c -  ӽ  ƾ  ִ .
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "log.h"
#include "common.h"
#include "ticket.h"

#define ROVM_CODE_DEBUG(EXPN)           /* nothing */

#define GETPC(OFFSET)                   CORE_OP_IDX (ri, pc + 1 + (OFFSET))

#define PUSH(N)                         TICKET_SP (CORE_TICKET (ri)) += (N)
#define POP(N)                          TICKET_SP (CORE_TICKET (ri)) -= (N)
/** Stack ȣ  - (̳ʽ)  ٴ  ϱ ٶ.  */
#define	STACK(N)                        (&TICKET_SP (CORE_TICKET (ri))[-(N)])
#define RSTACK                          STACK

/**   ˻ϴ ũ̴.  MINNUM  û ּ ؾ ϴ 
    ä slot   ǹϸ  װͺ ۴ٸ -1  ȯ . */
#define _CB_(MINNUM)                                                    \
  if ((TICKET_STACK (CORE_TICKET (ri)) + (MINNUM - 1)) > TICKET_SP (CORE_TICKET (ri))) \
    {                                                                   \
      request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK,    \
                         "Overflow of Stack Boundary");                 \
      return -1;                                                        \
    }

#define _CHAR_(NODE)                    SET_STACK_TYPE (NODE, STACK_TYPE_CHAR)
#define _INT_(NODE)                     SET_STACK_TYPE (NODE, STACK_TYPE_INT)

#define	ADD_INT(DST, SRC1, SRC2)                                        \
  _CB_ (2);                                                             \
  STACK_V_INT (DST) = STACK_V_INT (SRC1) + STACK_V_INT (SRC2);          \
  _INT_ (DST)

#define MOVE_NUM_CHAR_CONST(DST, SRC)           \
  _CHAR_ (DST);                                 \
  STACK_V_CHAR (DST) = (SRC)

typedef char            rovm_int8_t;

#define CORE_REQUEST(NODE)              ((NODE)->r)
#define CORE_TICKET(NODE)               ((NODE)->tk)
#define CORE_OP(NODE)                   ((NODE)->op)
#define CORE_OP_IDX(NODE, IDX)          ((NODE)->op[(IDX)])
#define CODE_OPLEN(NODE)                ((NODE)->oplen)
#define CORE_NPC(NODE)                  ((NODE)->npc)
#define CORE_LOW(NODE)                  ((NODE)->low)
#define CORE_HIGH(NODE)                 ((NODE)->high)
#define CORE_IDX(NODE)                  ((NODE)->idx)

/**
    ӽ ȣϴ   ϱ  ϴ ü.   ü ǰ 
     ӽ  opcode  ȣ  ޵Ǵ argument  ּҷ ̱ ؼ
   ̴.
 */
struct rovmcore_info
{
  /**  request   ü.  */
  request_rec *r;
  /**   ӽ Ǵ ticket .  */
  struct ticket *tk;

  /**  ó  OPCODE.  */
  rc_opcode_t *op;
  /**  ó  OPCODE  .  */
  rc_size_t oplen;

  /**  PC (Program Counter).  */
  uint32_t volatile npc;

  /**  ӽŻ󿡼  Ӱ ϴ .  κ  lower Ʈ ٷµ,
      ȴ.  */
  int low;
  /**  ӽŻ󿡼  Ӱ ϴ .  κ  higher Ʈ ٷµ,
      ȴ.  */
  int high;
  /**  ӽŻ󿡼  Ӱ ϴ .  Index ȣ ٷ  ȴ.  */
  int idx;  
};

enum opcode
  {
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   ENUM ,
#include "opcode.def"
#undef DEF_OPCODE
    MAX_OPCODE
  };

/**
    Opcode   ̿  迭.  Opcode  Ǿ ,
   virtual machine   PC (Program Counter)   PC 
     ȴ.  
*/
const int opcode_len[MAX_OPCODE] = 
  {
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   OPLEN ,
#include "opcode.def"
#undef DEF_OPCODE
  };

const char *opcode_name[MAX_OPCODE] = 
  {
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   NAME ,
#include "opcode.def"
#undef DEF_OPCODE
  };

/**
   OPCODEFUNC_* Լ   Ǵ ڵ  ũ̴.
     Ǹ ü Լ  ǰ ȴ.
 */
#define OPCODEFUNC_ARGUMENT     struct rovmcore_info *ri, unsigned int pc
/**
   OPCODEFUNC_* Լ  Ÿ ϴ ũ̴.
 */
#define OPCODEFUNC_RET_T        int

/**
   OPCODEFUNC_* Լ prototype 
 */
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   OPCODEFUNC_RET_T OPFUNC (OPCODEFUNC_ARGUMENT);
#include "opcode.def"
#undef DEF_OPCODE

/**
   OPCODEFUNC_* Լ  迭
 */
OPCODEFUNC_RET_T (*opcode_func[MAX_OPCODE]) (OPCODEFUNC_ARGUMENT) = 
{
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   OPFUNC ,
#include "opcode.def"
#undef DEF_OPCODE  
};

/** [0 (0x0)] OPCODE `NOP'  óѴ.  */
OPCODEFUNC_RET_T
opcodefunc_nop (OPCODEFUNC_ARGUMENT)
{
  /* nothing to do.  */
  return 0;
}

/** [16 (0x10)] OPCODE `CPUSH'  óѴ.  */
OPCODEFUNC_RET_T
opcodefunc_cpush (OPCODEFUNC_ARGUMENT)
{
  CORE_LOW (ri) = (rovm_int8_t) GETPC (0);

  ROVM_CODE_DEBUG (("cpush\t%d", CORE_LOW (ri)));
  PUSH (1);
  MOVE_NUM_CHAR_CONST (STACK (0), CORE_LOW (ri));

  return 0;
}

/** [90 (0x60)] OPCODE `IADD'  óѴ.  */
OPCODEFUNC_RET_T
opcodefunc_iadd (OPCODEFUNC_ARGUMENT)
{
  ROVM_CODE_DEBUG (("iadd"));

  ADD_INT (STACK (1), RSTACK (1), RSTACK (0));
  POP (1);

  return 0;
}

/**
   OPCODE    ʾҰų, ߿   ̸  
    ȣǾ , Ǵ callback Լ̴.   Լ ȣǾ 
   ʵȴ.
 */
OPCODEFUNC_RET_T
opcodefunc_reserved (OPCODEFUNC_ARGUMENT)
{
  /* ⿡ ߴٴ  opcode   opcode   ִٴ 
     Ѵ.  ̰ ߸  ̴.  */

  request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK,
                     "Invalid Opcode");

  return -1;
}

/**
    ӽ 󿡼  opcode  Ű Լ.
 */
rc_status_t
rovmcore (ri)
     struct rovmcore_info *ri;
{
  /* ???  δ Ʒ PC  register  Ѵٰ ϴ 
         ӵ         .   ǰ ³?  */
  register unsigned int pc;

  while (1)
    {
      pc = CORE_NPC (ri);
      
      CORE_NPC (ri) = pc + opcode_len[(CORE_OP_IDX (ri, pc))];

      if (opcode_func[(CORE_OP_IDX (ri, pc))] (ri, pc))
        return -1;

      if (CORE_NPC (ri) >= CODE_OPLEN (ri))
        break;
    }

  return 0;
}

/**
   ROVMCORE_INFO ü Ӱ ҴϿ ȯѴ.

   @param r     Request ü
   @param tk    ڰ ϰ ϴ Ticket ü
   @return      Ӱ Ҵ ROVMCORE_INFO ü ȯѴ.
 */
struct rovmcore_info *
init_rovmcore_info (r, tk, op, oplen)
     request_rec *r;
     struct ticket *tk;
     rc_opcode_t *op;
     rc_size_t oplen;
{
  struct rovmcore_info *ri;

  ri = (struct rovmcore_info *) mp_alloc (REQUEST_POOL (r), sizeof (struct rovmcore_info));
  CORE_REQUEST (ri) = r;
  CORE_TICKET (ri) = tk;
  CORE_NPC (ri) = 0;

  CORE_OP (ri) = op;
  CODE_OPLEN (ri) = oplen;

  return ri;
}

/**
    Ϸ ROVMCORE_INFO ü ϷѴ.

   @param ri    ϱ ϴ ROVMCORE_INFO ü.
 */
int
finish_rovmcore_info (ri)
     struct rovmcore_info *ri;
{
  /* nothing.  */

  return 0;
}

/**
   Request `OPCODE'  óϱ   VM Լ  ϳ̴.  ݿ ۵
   ̰ OPLEN ̰ OP  opcode  óϰ ȴ.

   @param r     Request ü
   @param tk    ڰ ϰ ϴ Ticket ü
   @param op    ڰ  opcode
   @param oplen ڰ  opcode   
   @return        VM  Ǿٸ 0  ȯϰ ׷ ʴٸ
                -1  ȯϰ ȴ.
 */
int
rovmcore_main (r, tk, op, oplen)
     request_rec *r;
     struct ticket *tk;
     rc_opcode_t *op;
     rc_size_t oplen;
{
  int rv;
  struct rovmcore_info *ri;

  ri = init_rovmcore_info (r, tk, op, oplen);
  if (!ri)
    return -1;

  rv = rovmcore (ri);

  finish_rovmcore_info (ri);

  return rv;
}
