/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_REQUEST_H
#define _ROVM_REQUEST_H

#define	ERRLOG_EMERG		0	/* system is unusable */
#define	ERRLOG_ALERT		1	/* action must be taken immediately */
#define	ERRLOG_CRIT		2	/* critical conditions */
#define	ERRLOG_ERR		3	/* error conditions */
#define	ERRLOG_WARNING		4	/* warning conditions */
#define	ERRLOG_NOTICE		5	/* normal but significant condition */
#define	ERRLOG_INFO		6	/* informational */
#define	ERRLOG_DEBUG		7	/* debug-level messages */

#define	ERRLOG_LEVELMASK	7	/* mask off the level value */

#define ERRLOG_WITHERRNO	(ERRLOG_LEVELMASK + 1)
#define ERRLOG_MARK		__FILE__,__LINE__

#define ERRORS_LEVEL(NODE)		((NODE)->level)
#define ERRORS_STRING(NODE)		((NODE)->str)
#define ERRORS_NEXT(NODE)		((NODE)->next)

/**
   Request  óϸ鼭 ߻   , ش ޼ linked-list
    Ǿ ϰ Ǹ,  ڿ ޵ǰ ȴ.
 */
struct request_errors
{
  /**  Ȥ exception  error level.   ǵ ERRLOG_* ũθ
      ϶.  */
  char level;
  /**  ڿ.  */
  char *str;

  struct request_errors *next;
};

#define REQUEST_CONN(NODE)              ((NODE)->conn)
#define REQUEST_POOL(NODE)              ((NODE)->pool)
#define REQUEST_ERRORS(NODE)            ((NODE)->errors)

/**
   Request     ִ üԴϴ.
 */
struct request_rec
{
  /**   Connection   ִ .  */
  conn_rec *conn;

  /** Reqeuest   ޸ Ǯ.  Connection ü  ޴´.  */
  rc_pool_t *pool;

  /**  request  óϸ鼭  鿡  linked-list.  ̰ connection 
      ߰ ڱ  ʴ ,   κп client   ȴ.  */
  struct request_errors *errors;
};

typedef struct request_rec request_rec;

extern int rc_process_request (conn_rec *);
extern int request_add_error (request_rec *r, int level, const char *file, int line, const char *fmt, ...);

#endif
