/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "types.h"
#include "mpool.h"
#include "thread_mutex.h"

/*
   Ͽ   locking ī  wrapper  Ǿ ֽϴ.

  !Ʈ! ũθ ̿ ʴ   ؼ Դϴ.
 */

/**
   Lock  õѴ.

   @param m	Thread Mutex .
 */
rc_status_t
rc_thread_mutex_lock (m)
     rc_thread_mutex_t *m;
{
  return apr_thread_mutex_lock (m);
}

/**
   TryLock  õѴ.

   @param m	Thread Mutex .
 */
rc_status_t
rc_thread_mutex_trylock (m)
     rc_thread_mutex_t *m;
{
  return apr_thread_mutex_trylock (m);
}

/**
   Unlock  õѴ.

   @param m	Thread Mutex .
 */
rc_status_t
rc_thread_mutex_unlock (m)
     rc_thread_mutex_t *m;
{
  return apr_thread_mutex_unlock (m);
}

/**
   Thread Mutex  Ѵ.   Լ Memory Pool  ̿Ѵ.

   @param m	 Mutex 
   @param flags	ɼ
   @param p	Memory pool 
 */
rc_status_t
rc_thread_mutex_create (m, flags, p)
     rc_thread_mutex_t **m;
     unsigned int flags;
     rc_pool_t *p;
{
  return apr_thread_mutex_create (m, flags, p);
}

/**
    thread mutex  Ѵ.

   @param m	 thread mutex 
 */
rc_status_t
rc_thread_mutex_destroy (m)
     rc_thread_mutex_t *m;
{
  return apr_thread_mutex_destroy (m);
}
