/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_CORE_H
#define _ROVM_CORE_H

/**
   @file core.h
   @breif ROVM   virtual machine  õ ƾ .
*/

/**
   @defgroup ROVM  ӽ
   @{
*/

enum rovm_stack_type
  {
    /** ƹ stack type   , ̰ ȴ. */
    STACK_TYPE_VOID,
    /** Stack  Char Ÿ .  */
    STACK_TYPE_CHAR,
    /** Stack  Unsigned Char Ÿ .  */
    STACK_TYPE_UCHAR,
    /** Stack  Integer Ÿ .  */
    STACK_TYPE_INT,
    /** Stack  Unsigned Integer Ÿ .  */
    STACK_TYPE_UINT,
    /** ޸ ּ   slot  , ̰ ȴ.  */
    STACK_TYPE_OBJREF,
    MAX_STACK_TYPE
  };

#define STACK_TYPE(NODE)                ((NODE)->type)
#define SET_STACK_TYPE(NODE, TYPE)      (NODE)->type = TYPE
#define STACK_V_CHAR(NODE)              ((NODE)->v._char)
#define STACK_V_INT(NODE)               ((NODE)->v._int)
#define STACK_V_ADDR(NODE)              ((NODE)->v._addr)

/**
    ӽ ϴ  ǥϴ üν  ϳ ϳ  slot 
   Ÿ.

   @note  2005 1 29 δ ROVM  õ  ޸  κе
         struct ticket ü  ִ  谡 Ǿ ִ.   ROVM
          ϴ  ޸ ü ticket ü    ̸
         ؼ  ǵ 谡 Ǿ ִٴ ̴.

         ̷ ϴ  VM  ϴٺ     ִ ޸
          κ   ϱ ؼ̴.
 */
struct rovm_stack
{
  /**
      type  Ÿ ؼ Ǵ ̴.    type δ
     Ʒ   ǵǾ ִ.

       - STACK_TYPE_NUMBER
       - STACK_TYPE_OBJREF

     ̰ ǵ   ߻  ִ objref + number  
      Ͽ  exception  ߻Ű ؼ̴.
   */
  unsigned type : 4;

  /**   ,  bit.  */
  unsigned unused : 4;

  /**
        Ǵ union ü.

     @note (20060129)  Ȯ   ʱ ,  ټ 
            ִ.   Ʒ  type  , ӽŸ Ϸ 
           ũⰡ ٸ  ̿  ϵ    ʾ, ٸ
           ӽ Ȥ Ϸ   α׷ ȵư  ٺϴ.
   */
  union
  {
    char _char;                 /**< 1 Ʈ char  .  */
    unsigned char _uchar;       /**< 1 Ʈ unsigned char  .  */
    int _int;                   /**< 4 Ʈ integer  .  */
    void *_addr;                /**< ּ   .  */
  } v;
};

typedef struct rovm_stack rovm_stack_t;

struct ticket;
extern int rovmcore_main (request_rec *, struct ticket *, rc_opcode_t *, rc_size_t);

/**
   @}
*/

#endif
