#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "log.h"
#include "common.h"
#include "ticket.h"
#include "utils.h"

/** GC  Ǵ ֱ.   60 ʸ ѹݾ  ǵ Ǿ 
    ֽϴ.

    ???   ROVM  Ͽ   ?  */
#define DEFAULT_GC_SLEEP_TIME           (60 * 1000000)

extern rc_gc_t *init_ggc (void (*ggc_marker) (rc_gc_t *G), void *);
extern void *ggc_getarg (rc_gc_t *);
extern void ggc_setarg_always_collect (rc_gc_t *);
extern void ggc_collect (rc_gc_t *);
extern void *ggc_alloc_stat (rc_gc_t *, size_t);
extern void ggc_free (void *);
extern void ggc_setarg_quiet_flag (rc_gc_t *, int);
extern int ggc_set_mark (rc_gc_t *, const void *);

/**
   Thread  argument üԴϴ.
 */
struct thread_gc
{
  /** Thread   ޸ pool.  */
  rc_pool_t *p;
  /** Thread Attribute.  */
  rc_threadattr_t *threadattr;

  /** ROVM ü.  */
  struct rovm *r;
};

/**
    P  marking  ȵ GC ޸ , ش ޸𸮸 marking ϰ
    0  ȯմϴ.  ׷  , 1  ȯϰ ˴ϴ.

   @param r     ROVM 
   @param p     Marking  ޸ .  ݵ GC ޸ ; Ѵ.
 */
int
gc_set_mark (r, p)
     struct rovm *r;
     const void *p;
{
  return ggc_set_mark (ROVM_GC (r), p);
}

/**
   Ticket Tree  walking   , ȣǴ callback ԼԴϴ.
    κп Ticket Tree   marking  ̷ ˴ϴ.

   @param node  ش node    .
 */
int
rovm_gc_tktree_walking_cb (tktree_node_t node, void *arg)
{
  struct rovm *r = (struct rovm *) arg;
  struct ticket *tk;
  rovm_stack_t *p;

  tk = (struct ticket *) node->value;

  /* ObjectRef  óմϴ.  ù° ܰ Stack Slot  ִ  մϴ.  */
  for (p = TICKET_STACK (tk); p <= TICKET_SP (tk); p++)
    {
      if (STACK_TYPE (p) == STACK_TYPE_OBJREF)
        gc_set_mark (r, STACK_V_ADDR (p));
    }
  /* ObjectRef  óմϴ.  ι° ܰ Stack Return Slot  ִ  մϴ.  */
  if (STACK_TYPE (TICKET_RET (tk)) == STACK_TYPE_OBJREF)
    gc_set_mark (r, STACK_V_ADDR (TICKET_RET (tk)));

  return 0;
}

/**
   Marker callback ԼԴϴ.   Լ ggc_collect ()   
   Garbage Collection  Ͼ  ڵ ȣǴ Լ̸, init_ggc ()
   Լ ù° ڷν ǳ ˴ϴ.

   @param G     GC  ü  
 */
void
rovm_gc_mark_roots (rc_gc_t *G)
{
  struct rovm *r = (struct rovm *) ggc_getarg (G);

  /*
     Լ ȣǾ  Garbage Collector   Ҵ  ޸
    entry  marking  clean   Դϴ.

    Ʒ  ִ  ֵǴ GC ޸𸮵   üũ
    ־ մϴ.   Ʒ  ҵ GC ޸𸮸 ϰ ֽϴ.

      1) Object Reference
          Object  GC ޸𸮸 ϵ մϴ.  Object Ref 
         VM  ϴ   ϰ ҴǸ,  Դϴ.
  */

  /*
    ROVM Server  Garbage Collection .

    1) Object Reference   Garbage Collection .

        ObjectRef  Ticket ü Stack Կ  
       Ǿ ֽϴ.

       ,  ObjectRef  ִ ̶

         ˻ = (Ticket ü sp  - Ticket ü stack )
         ˻ += (Ticket ü ret )

        ˻ ׻   Դϴ.     
       ʴ´ٸ  ObjectRef  Դϴ.

       ˻ Stack Կ STACK_TYPE (NODE)  STACK_TYPE_OBJREF
        ͸ marking  ϰ ˴ϴ.   marking   ʴ ͵
        ޸  Դϴ.

        Garbage Collection  ̷ , ٸ 忡  sp
        ǰ Ǹ װ   ʽϴ.  ֳϸ Ʒ 
       찡   ֱ Դϴ.

         a.  sp ȴٰ ϴ, ִ ObjectRef  ״ marking
              ̸,  ObjectRef  marking    ȵǴ,
             Garbage Collection   ̴.
  */

  /* Ticket Tree   walking  ô.  */
  tktree_walking (ROVM_TKTREE (r), rovm_gc_tktree_walking_cb, (void *) r);
}

/**
   Garbage Collector Thread  main Լ.

   @param thd   Thread ID
   @param arg   . (struct thread_gc ü)
 */
static void * 
gc_threads (rc_thread_t *thd, void *arg)
{
  struct thread_gc *tg = (struct thread_gc *) arg;

  if (!tg || (tg && !tg->r))
    {
      rc_thread_exit (thd, RC_SUCCESS);
      return NULL;
    }

  while (1)
    {
      /*
        Garbage Collection  Ͼ ߰ gc_alloc () Լ 
        ޸ Ҵ  ˴ϴ.
      */
      rc_thread_mutex_lock (ROVM_GC_MUTEX (tg->r));
      ggc_collect (ROVM_GC (tg->r));
      rc_thread_mutex_unlock (ROVM_GC_MUTEX (tg->r));
      rc_sleep (rc_time_make (0, DEFAULT_GC_SLEEP_TIME));
    }

  rc_thread_exit (thd, RC_SUCCESS);

  return NULL;
}

/**
   Garbage Collector Thread  Ѵ.

   @param r     ROVM ü
   @return         0 , ׷  , -1  ȯѴ.
 */
int
gc_run (r)
     struct rovm *r;
{
  rc_status_t rv;
  rc_thread_t *gc_thread_id;
  rc_threadattr_t *thread_attr;
  rc_pool_t *p;
  struct thread_gc *tg;

  mp_create (&p, PROCREC_PCONF (ROVM_PROCESS (r)));

  rc_threadattr_create (&thread_attr, p);
  /* 0  PTHREAD_CREATE_JOINABLE  ǹѴ.  */
  rc_threadattr_detach_set (thread_attr, 0);

  tg = (struct thread_gc *) mp_alloc (p, sizeof (*tg));
  tg->threadattr = thread_attr;
  tg->p = p;
  tg->r = r;

  rv = rc_thread_create (&gc_thread_id, thread_attr, gc_threads, tg, p);
  if (rv != RC_SUCCESS)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK,
		"rc_thread_create: unable to create worker thread");
      return -1;
    }

  return 0;
}

/**
   GC ޸𸮸 Ҵմϴ.

   @param r     ROVM ü
   @param size  Ҵ ޸ ũ
 */
void *
gc_alloc (r, size)
     struct rovm *r;
     size_t size;
{
  void *p;

  /*
    ggc_collect () Լ Ǵ ȿ ޸ Ҵ  ϵ
    Ե˴ϴ.
   */
  rc_thread_mutex_lock (ROVM_GC_MUTEX (r));
  p = ggc_alloc_stat (ROVM_GC (r), size);
  rc_thread_mutex_unlock (ROVM_GC_MUTEX (r));

  return p;
}

/**
   GC ޸𸮸 մϴ.  ٷ  , ܼ ش gc ׸
   ⸸ մϴ.
 */
void
gc_free (p)
     void *p;
{
  ggc_free (p);
}

/**
   ROVM  Garbage Collector  Ų.

   @param r     ROVM ü
 */
int
init_rovm_gc (r, p)
     struct rovm *r;
     rc_pool_t *p;
{
  rc_status_t rv;

  ROVM_GC (r) = init_ggc (rovm_gc_mark_roots, r);
  if (!ROVM_GC (r))
    return -1;

  ggc_setarg_always_collect (ROVM_GC (r));
  ggc_setarg_quiet_flag (ROVM_GC (r), 1);

  rv = rc_thread_mutex_create (&ROVM_GC_MUTEX (r), RC_THREAD_MUTEX_DEFAULT, p);
  if (rv != RC_SUCCESS)
    return -1;
 
  return 0;
}
