/* core.c -  ӽ  ƾ  ִ .
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "log.h"
#include "common.h"
#include "ticket.h"
#include "utils.h"

#include "class.h"
#include "file.h"

#define ROVM_CODE_DEBUG(EXPN)           /* nothing */

#define GETPC(OFFSET)                   CORE_OP_IDX (ri, pc + 1 + (OFFSET))

#define PUSH(N)                         TICKET_SP (CORE_TICKET (ri)) += (N); _MAX_CB_ (0);
#define POP(N)                          TICKET_SP (CORE_TICKET (ri)) -= (N); _MIN_CB_ (0);
/** Stack ȣ  - (̳ʽ)  ٴ  ϱ ٶϴ.  */
#define	STACK(N)                        (&TICKET_SP (CORE_TICKET (ri))[-(N)])
#define RSTACK                          STACK

#define LOCAL(N)                        (&TICKET_LOCAL (CORE_TICKET (ri))[(N)])

#define _LOCK_(UNUSED)                  rc_thread_mutex_lock (TICKET_MUTEX (CORE_TICKET (ri)))
#define _UNLOCK_(UNUSED)                rc_thread_mutex_unlock (TICKET_MUTEX (CORE_TICKET (ri)))

/**
     ˻ϴ ũην, PUSH Ȥ POP Operation  ߻Ͽ ,
   Ǵ κԴϴ.
   
   _MAX_CB_  Stack  ִ ͸ ˻մϴ.
*/
#define _MAX_CB_(NOT)                                                   \
  if (TICKET_SP (CORE_TICKET (ri)) >= TICKET_MAX_SP (CORE_TICKET (ri))) \
    {                                                                   \
      request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK,    \
                         "Overflow of Stack Boundary");                 \
      return -1;                                                        \
    }
/**
     ˻ϴ ũην, PUSH Ȥ POP Operation  ߻Ͽ ,
   Ǵ κԴϴ.  
   
   _MIN_CB_  Stack  ּ ͸ ˻մϴ.
*/
#define _MIN_CB_(NOT)                                                   \
  if (TICKET_SP (CORE_TICKET (ri)) < TICKET_MIN_SP (CORE_TICKET (ri)))  \
    {                                                                   \
      request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK,    \
                         "Underflow of Stack Boundary");                \
      return -1;                                                        \
    }
/**
     ˻ϴ ũ̴.  MINNUM  û ּ ؾ ϴ 
   ä slot   ǹϸ  װͺ ۴ٸ -1  ȯ . 
*/
#define _CB_(MINNUM)                                                    \
  if ((TICKET_STACK (CORE_TICKET (ri)) + (MINNUM - 1)) > TICKET_SP (CORE_TICKET (ri))) \
    {                                                                   \
      request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK,    \
                         "Overflow of Stack Boundary");                 \
      return -1;                                                        \
    }

/**
   Local   ˻ϴ ũ̴.
 */
#define _CLB_(IDX)                                                      \
  if (IDX < 0                                                           \
      || &(TICKET_LOCAL (CORE_TICKET (ri))[(IDX)]) >= TICKET_MAXLOCAL (CORE_TICKET (ri))) \
    {                                                                   \
      request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK,    \
                         "Overflow of Local Variable Boundary");        \
      return -1;                                                        \
    }

/**
    SLOT  STACK_TYPE_OBJREF  ,  ϰ  . 
    , `ADD' opcode  ڰ ִ stack slot  objectref 
   ȵǱ ̴.
*/
#define _DENY_OBJREF(SLOT)                                              \
  if (STACK_TYPE (SLOT) == STACK_TYPE_OBJREF)                           \
    {                                                                   \
      request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK,    \
                         "Invalid operation");                          \
      return -1;                                                        \
    }

/*
  Ʒ _CHAR_, _INT_, _OBJREF_ ũθ    ֽϴ.
  װ stack  type  ٲ , ش stack slot    operation 
  ̷ Ŀ  ٲ Ѵٴ Դϴ.

   ``Garbage Collection'' ̷  ٸ 忡 VM 
     ִµ, race condition  ؼ   marking Ǵ 
   ؼ Դϴ.     marking  , SEGV  ߻ ɼ
  ſ ϴ.
 */
/**  Stack Slot  INT type  Ѵ.  */
#define _INT_(NODE)                     SET_STACK_TYPE (NODE, STACK_TYPE_INT)
#define _CHAR_(NODE)                    SET_STACK_TYPE (NODE, STACK_TYPE_CHAR)
/**  Stack Slot  OBJREF type  Ѵ.  */
#define _OBJREF_(NODE)                  SET_STACK_TYPE (NODE, STACK_TYPE_OBJREF)
#define _ARRAYREF_(NODE)                SET_STACK_TYPE (NODE, STACK_TYPE_ARRAYREF)

#define	ADD_INT(DST, SRC1, SRC2)                                        \
  _CB_ (2);                                                             \
  _DENY_OBJREF (SRC1);                                                  \
  _DENY_OBJREF (SRC2);                                                  \
  STACK_V_INT (DST) = STACK_V_INT (SRC1) + STACK_V_INT (SRC2);          \
  /* ׻ _INT_ ũδ  κп.  */                             \
  _INT_ (DST)

#define MOVE_CHAR_CONST(DST, SRC)               \
  STACK_V_CHAR (DST) = (SRC);                    \
  /* ׻ _CHAR_ ũδ  κп~  */     \
  _CHAR_ (DST)

#define MOVE_INT_CONST(DST, SRC)                \
  STACK_V_INT (DST) = (SRC);                    \
  /* ׻ _INT_ ũδ  κп~  */     \
  _INT_ (DST)

#define MOVE_INT(DST, SRC)                      \
  STACK_V_INT (DST) = STACK_V_INT (SRC);        \
  /* ׻ _INT_ ũδ  κп.  */     \
  _INT_ (DST)

#define MOVE_OBJREF(DST, SRC)                   \
  STACK_V_ADDR (DST) = (void *) (SRC);          \
  /* ׻ _OBJREF_ ũδ  κп~  */  \
  _OBJREF_ (DST)

#define MOVE_ARRAYREF(DST, SRC)                 \
  STACK_V_ADDR (DST) = (void *) (SRC);          \
  _ARRAYREF_ (DST)

typedef char            rovm_int8_t;
typedef unsigned char   rovm_uint8_t;

/** request_rec  ϴ pool  ϰ  ֵ  ũ̴.  */
#define CORE_POOL(NODE)                 (REQUEST_POOL (CORE_REQUEST (NODE)))

#define CORE_ROVM(NODE)                 REQUEST_ROVM (CORE_REQUEST (NODE))
#define CORE_REQUEST(NODE)              ((NODE)->r)
#define CORE_TICKET(NODE)               ((NODE)->tk)
#define CORE_OP(NODE)                   ((NODE)->op)
#define CORE_OP_IDX(NODE, IDX)          ((NODE)->op[(IDX)])
#define CORE_OPLEN(NODE)                ((NODE)->oplen)
#define CORE_NPC(NODE)                  ((NODE)->npc)
#define CORE_LOW(NODE)                  ((NODE)->low)
#define CORE_HIGH(NODE)                 ((NODE)->high)
#define CORE_IDX(NODE)                  ((NODE)->idx)

/**
    ӽ ȣϴ   ϱ  ϴ ü.   ü ǰ 
     ӽ  opcode  ȣ  ޵Ǵ argument  ּҷ ̱ ؼ
   ̴.
 */
struct rovmcore_info
{
  /**  request   ü.  */
  request_rec *r;
  /**   ӽ Ǵ ticket .  */
  struct ticket *tk;

  /**  ó  OPCODE.  */
  rc_opcode_t *op;
  /**  ó  OPCODE  .  */
  rc_size_t oplen;

  /**  PC (Program Counter).  */
  uint32_t npc;

  /**  ӽŻ󿡼  Ӱ ϴ .  κ  lower Ʈ ٷµ,
      ȴ.  */
  int low;
  /**  ӽŻ󿡼  Ӱ ϴ .  κ  higher Ʈ ٷµ,
      ȴ.  */
  int high;
  /**  ӽŻ󿡼  Ӱ ϴ .  Index ȣ ٷ  ȴ.  */
  int idx;  
};

enum opcode
  {
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   ENUM ,
#include "opcode.def"
#undef DEF_OPCODE
    MAX_OPCODE
  };

/**
    Opcode   ̿  迭.  Opcode  Ǿ ,
   virtual machine   PC (Program Counter)   PC 
     ȴ.  
*/
const int opcode_len[MAX_OPCODE] = 
  {
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   OPLEN ,
#include "opcode.def"
#undef DEF_OPCODE
  };

const char *opcode_name[MAX_OPCODE] = 
  {
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   NAME ,
#include "opcode.def"
#undef DEF_OPCODE
  };

/**
   OPCODEFUNC_* Լ   Ǵ ڵ  ũ̴.
     Ǹ ü Լ  ǰ ȴ.
 */
#define OPCODEFUNC_ARGUMENT     struct rovmcore_info *ri, unsigned int pc
/**
   OPCODEFUNC_* Լ  Ÿ ϴ ũ̴.
 */
#define OPCODEFUNC_RET_T        static int

/**
   OPCODEFUNC_* Լ prototype 
 */
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   OPCODEFUNC_RET_T OPFUNC (OPCODEFUNC_ARGUMENT);
#include "opcode.def"
#undef DEF_OPCODE

/**
   OPCODEFUNC_* Լ  迭
 */
OPCODEFUNC_RET_T (*opcode_func[MAX_OPCODE]) (OPCODEFUNC_ARGUMENT) = 
{
#define DEF_OPCODE(ENUM, NAME, NUMBER, OPLEN, OPFUNC)   OPFUNC ,
#include "opcode.def"
#undef DEF_OPCODE  
};

/**
    stack type   ڸ  ִ 迭Դϴ.
 */
const char rovm_stack_char[MAX_STACK_TYPE] = 
  {
#define DEF_TYPE(ENUM, NAME, TYPE, SIZE)   TYPE ,
#include "type.def"
#undef DEF_TYPE
  };

/**  stack type   ũ⸦ Ű 迭Դϴ.  */
int rovm_stack_size[MAX_STACK_TYPE] = 
  {
#define DEF_TYPE(ENUM, NAME, TYPE, SIZE)   SIZE ,
#include "type.def"
#undef DEF_TYPE
  };

/** [0 (0x0)] OPCODE `NOP'  óѴ.  */
OPCODEFUNC_RET_T
opcodefunc_nop (OPCODEFUNC_ARGUMENT)
{
  /* nothing to do.  */
  return 0;
}

/** [16 (0x10)] OPCODE `CPUSH'  óѴ.  */
OPCODEFUNC_RET_T
opcodefunc_cpush (OPCODEFUNC_ARGUMENT)
{
  CORE_LOW (ri) = (rovm_int8_t) GETPC (0);

  ROVM_CODE_DEBUG (("cpush\t%d", CORE_LOW (ri)));

  PUSH (1);
  MOVE_CHAR_CONST (STACK (0), CORE_LOW (ri));

  return 0;
}

/** [18 (0x12)] OPCODE `IPUSH'  óѴ.  */
OPCODEFUNC_RET_T
opcodefunc_ipush (OPCODEFUNC_ARGUMENT)
{
  int val = (int) ((int *) (&GETPC (0)))[0];

  ROVM_CODE_DEBUG (("ipush\t%d", val));

  PUSH (1);
  MOVE_INT_CONST (STACK (0), val);

  return 0;
}

/** [19 (0x13)] OPCODE `SPUSH'  óѴ.   opcode Դϴ.

    Locking Ŀ  ʿ opcode Դϴ.  */
OPCODEFUNC_RET_T
opcodefunc_spush (OPCODEFUNC_ARGUMENT)
{
  size_t len;
  RvObject *obj;

  ROVM_CODE_DEBUG (("spush"));

  len = (unsigned int) ((unsigned int *) (&GETPC (0)))[0];

  if ((pc + 4 + len) >= (CORE_OPLEN (ri)))
    return -1;

  CORE_NPC (ri) = pc + (5 + len);

  /* Locking Ŀ ϴ  gc_alloc ()  Ҵ   
     Ticket Stack Slot  ϵǴ  ſ  ð ̰ ֱ 
     ̷ ߻  ִ   ϱ ؼ ˴ϴ.  */
  _LOCK_ ();

  obj = NewRvStringObject (CORE_ROVM (ri), (const char *) (&GETPC (4)), len);
  if (!obj)
    {
      _UNLOCK_ ();
      return -1;
    }

  PUSH (1);
  MOVE_OBJREF (STACK (0), obj);

  _UNLOCK_ ();

  return 0;
}

/** [21 (0x15)] OPCODE `ILOAD'  óѴ.  */
OPCODEFUNC_RET_T
opcodefunc_iload (OPCODEFUNC_ARGUMENT)
{
  CORE_IDX (ri) = (rovm_uint8_t) GETPC (0);

  ROVM_CODE_DEBUG (("iload\t%d", CORE_IDX (ri)));

  _CLB_ (CORE_IDX (ri));
  PUSH (1);
  MOVE_INT (STACK (0), LOCAL (CORE_IDX (ri)));

  return 0;
}

/** [90 (0x60)] OPCODE `IADD'  óѴ.  */
OPCODEFUNC_RET_T
opcodefunc_iadd (OPCODEFUNC_ARGUMENT)
{
  ROVM_CODE_DEBUG (("iadd"));

  ADD_INT (STACK (1), RSTACK (1), RSTACK (0));
  POP (1);

  return 0;
}

/** [172 (0xac)] OPCODE `IRETURN'  óѴ.  */
OPCODEFUNC_RET_T
opcodefunc_ireturn (OPCODEFUNC_ARGUMENT)
{
  ROVM_CODE_DEBUG (("ireturn"));

  *TICKET_RET (CORE_TICKET (ri)) = *STACK (0);
  POP (1);

  return 1;
}

/** [182 (0xb6)] OPCODE `CALL'  óѴ.  `CALL' opcode  , ̸
     opcode ̴.  */
OPCODEFUNC_RET_T
opcodefunc_call (OPCODEFUNC_ARGUMENT)
{
  int i, argc, hlen, tlen, ret = 0;
  char *name, *type;
  u2 *argv;

  hlen = (int) GETPC (0);
  name = rc_pstrndup (CORE_POOL (ri), (char *) (&GETPC (1)), hlen);
  tlen = (unsigned short) ((unsigned short *) (&GETPC (1 + hlen)))[0];
  type = rc_pstrndup (CORE_POOL (ri), (char *) (&GETPC (1 + hlen + 2)), tlen);

  ROVM_CODE_DEBUG (("call %s %s", name, type));

  CORE_NPC (ri) = pc + (5 + hlen+ tlen);

  /*  Ÿ ˻.  */
  argc = (int) calctype_argc ((u1 *) type);
  argv = calctype_argv ((u1 *) type, (u2) argc);
  for (i=0; i<argc; i++)
    {
      if (rovm_stack_char[STACK_TYPE (STACK (i))] != type[argv[argc-i-1]])
        {
          request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK, "Method type don't match.");
          return -1;
        }
    }

  if (rc_callmethod (CORE_REQUEST (ri), CORE_TICKET (ri), name, type, argc, argv))
    ret = -1;

  POP (argc);
  rc_free (argv);

  return ret;
}

/** [187 (0xbb)] OPCODE `NEW'  óѴ.  `NEW' opcode  , ̸
     opcode ̴.

    Locking Ŀ  ʿ opcode Դϴ.  */
OPCODEFUNC_RET_T
opcodefunc_new (OPCODEFUNC_ARGUMENT)
{
  int len, len2, iptype;
  char *hostname, *path;
  unsigned short port;
  RvObject *obj;
  RvClass *cls;
 
  iptype = (int) GETPC (0);
  len = (unsigned short) ((unsigned short *) (&GETPC (1)))[0];
  hostname = rc_pstrndup (CORE_POOL (ri), (char *) (&GETPC (3)), len);
  port = (unsigned short) ((unsigned short *) (&GETPC (3 + len)))[0];
  len2 = (unsigned short) ((unsigned short *) (&GETPC (5 + len)))[0];
  path = rc_pstrndup (CORE_POOL (ri), (char *) (&GETPC (7 + len)), len2);

  ROVM_CODE_DEBUG (("new e://%s:%d%s (%s)", 
                    hostname, 
                    port ? port : DEFAULT_ROVM_LISTENING_PORT,
                    path,
                    iptype ? "IPv6", "IPv4"));

  CORE_NPC (ri) = pc + (8 + len + len2);

  cls = rc_getclassbyhost (CORE_REQUEST (ri), iptype, hostname, port, path);
  if (cls == NULL_CLASS)
    {
      request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK, "Can't find class.");
      return -1;
    }

  _LOCK_ ();

  if (cls == REMOTE_CLASS)
    {
      obj = NewRemoteRvObject (CORE_REQUEST (ri), iptype, hostname, port, path);
      if (!obj)
        {
          request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK,
                             "NewRemoteRvObject is under construction.");
          _UNLOCK_ ();
          return -1;
        }
    }
  else
    obj = NewRvObject (cls);

  if (!obj)
    {
      request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK, "Can't allocate ObjectRef.");
      _UNLOCK_ ();
      return -1;
    }

  PUSH (1);
  MOVE_OBJREF (STACK (0), obj);

  _UNLOCK_ ();

  return 0;
}

/** [188 (0xbc)] OPCODE `NEWARRAY'  óѴ.  

    Locking Ŀ  ʿ opcode Դϴ.  */
OPCODEFUNC_RET_T
opcodefunc_newarray (OPCODEFUNC_ARGUMENT)
{
  RvValue *val;

  CORE_LOW (ri) = (rovm_int8_t) GETPC (0);

  ROVM_CODE_DEBUG (("newarray %d", CORE_LOW (ri)));

  _LOCK_ ();

  val = NewRvArray (CORE_ROVM (ri), CORE_LOW (ri), STACK_V_INT (STACK (0)));
  if (!val)
    {
      _UNLOCK_ ();
      return -1;
    }

  MOVE_ARRAYREF (STACK (0), val);

  _UNLOCK_ ();
  return 0;
}

/**
   OPCODE    ʾҰų, ߿   ̸  
    ȣǾ , Ǵ callback Լ̴.   Լ ȣǾ 
   ʵȴ.
 */
OPCODEFUNC_RET_T
opcodefunc_reserved (OPCODEFUNC_ARGUMENT)
{
  /* ⿡ ߴٴ  opcode   opcode   ִٴ 
     Ѵ.  ̰ ߸  ̴.  */

  request_add_error (CORE_REQUEST (ri), ERRLOG_ERR, ERRLOG_MARK,
                     "Invalid Opcode");

  return -1;
}

/**
    ӽ 󿡼  opcode  Ű Լ.  ٽ ڵ̴.   
   ª δٴ  ܿ.

   @param ri    ׻ opcode callback Լ ڷ Ѿ ̴.
   @return         ƹ  ٸ 0  ȯϰ Ǹ,
                ϳ    -1  ȯϰ ȴ.
 */
rc_status_t
rovmcore (ri)
     struct rovmcore_info *ri;
{
  /* ???  δ Ʒ PC  register  Ѵٰ ϴ 
         ӵ         .   ǰ ³?  */
  register unsigned int pc;
  register int rv;

  while (1)
    {
      pc = CORE_NPC (ri);
      
      CORE_NPC (ri) = pc + opcode_len[(CORE_OP_IDX (ri, pc))];

      rv = opcode_func[(CORE_OP_IDX (ri, pc))] (ri, pc);
      if (rv)
        {
          /*  opcode_func () Լ  ȯ 0  ƴ 쿡  ǹ̵
             Ʒ ٷϴ.  */
          switch (rv)
            {
            case -1:
              return -1;
            case 1:
              /* ireturn   opcode   ȯ , ȯ 1 Դϴ.  */
              return 0;
            default:
              rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK,
                        "Weird return value. Check it.");
              break;
            }
          return -1;
        }

      if (CORE_NPC (ri) >= CORE_OPLEN (ri))
        break;
    }

  return 0;
}

/**
   ROVMCORE_INFO ü Ӱ ҴϿ ȯѴ.

   @param r     Request ü
   @param tk    ڰ ϰ ϴ Ticket ü
   @return      Ӱ Ҵ ROVMCORE_INFO ü ȯѴ.
 */
struct rovmcore_info *
init_rovmcore_info (r, tk, op, oplen)
     request_rec *r;
     struct ticket *tk;
     rc_opcode_t *op;
     rc_size_t oplen;
{
  struct rovmcore_info *ri;

  /*  mp_alloc  rc_malloc  ü.   ӵǴ Լ ȣ  ޸
       ؼ.  */
  ri = (struct rovmcore_info *) rc_malloc (sizeof (struct rovmcore_info));
  CORE_REQUEST (ri) = r;
  CORE_TICKET (ri) = tk;
  CORE_NPC (ri) = 0;

  CORE_OP (ri) = op;
  CORE_OPLEN (ri) = oplen;

  return ri;
}

/**
    Ϸ ROVMCORE_INFO ü ϷѴ.

   @param ri    ϱ ϴ ROVMCORE_INFO ü.
 */
int
finish_rovmcore_info (ri)
     struct rovmcore_info *ri;
{
  rc_free (ri);

  return 0;
}

/**
   Request `OPCODE'  óϱ   VM Լ  ϳ̴.  ݿ ۵
   ̰ OPLEN ̰ OP  opcode  óϰ ȴ.

   @param r     Request ü
   @param tk    ڰ ϰ ϴ Ticket ü
   @param op    ڰ  opcode
   @param oplen ڰ  opcode   
   @return        VM  Ǿٸ 0  ȯϰ ׷ ʴٸ
                -1  ȯϰ ȴ.
 */
int
rovmcore_main (r, tk, op, oplen)
     request_rec *r;
     struct ticket *tk;
     rc_opcode_t *op;
     rc_size_t oplen;
{
  int rv;
  struct rovmcore_info *ri;

  ri = init_rovmcore_info (r, tk, op, oplen);
  if (!ri)
    return -1;

  rv = rovmcore (ri);

  finish_rovmcore_info (ri);

  return rv;
}
