/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_CORE_H
#define _ROVM_CORE_H

/**
   @file core.h
   @breif ROVM   virtual machine  õ ƾ .
*/

typedef struct rovm_stack RvValue;
typedef struct rovm_stack rovm_stack_t;

#define ROVM_EVALUE_TYPEDEF     /**< el.h  浹  .  */

/** Value    ̸ ȯϰ ȴ.  */
#define NULL_VALUE              (RvValue *) 0

/**
   @defgroup ROVM  ӽ
   @{
*/

enum rovm_stack_type
  {
#define DEF_TYPE(ENUM, NAME, TYPE, SIZE)   ENUM ,
#include "type.def"
#undef DEF_TYPE
    /*  ʴ Stack Type.  */
    DUMMY_STACK_TYPE
  };

/**  ROVM Server 󿡼 Stack Type    ǹѴ.   
    type.def Ͽ Ǿ Ƿ װ Ѵ.  */
#define MAX_STACK_TYPE                  6

#define STACK_TYPE(NODE)                ((NODE)->type)
#define STACK_SUBTYPE(NODE)             ((NODE)->subtype)
#define SET_STACK_TYPE(NODE, TYPE)      (NODE)->type = TYPE
#define STACK_IS_ARRAY(NODE)            ((NODE)->is_array)
#define STACK_ARRAYLEN(NODE)            ((NODE)->arraylen)
#define STACK_V_CHAR(NODE)              ((NODE)->v._char)
#define STACK_V_INT(NODE)               ((NODE)->v._int)
#define STACK_V_ADDR(NODE)              ((NODE)->v._addr)

/**
    ӽ ϴ  ǥϴ üν  ϳ ϳ  slot 
   Ÿ.

   @note  2005 1 29 δ ROVM  õ  ޸  κе
         struct ticket ü  ִ  谡 Ǿ ִ.   ROVM
          ϴ  ޸ ü ticket ü    ̸
         ؼ  ǵ 谡 Ǿ ִٴ ̴.

         ̷ ϴ  VM  ϴٺ     ִ ޸
          κ   ϱ ؼ̴.
 */
struct rovm_stack
{
  /**
      type  Ÿ ؼ Ǵ ̴.    type δ
     Ʒ   ǵǾ ִ.

       - STACK_TYPE_NUMBER
       - STACK_TYPE_OBJREF

     ̰ ǵ   ߻  ִ objref + number  
      Ͽ  exception  ߻Ű ؼ̴.
   */
  unsigned type : 4;

  /**  stack slot  迭   ,  flag  1  ȴ.  */
  unsigned is_array : 1;
  /**   stack slot  迭 ,  type   迭 
        ֽϴ.  */
  unsigned subtype : 4;

  /**   ,  bit.  */
  unsigned unused : 23;

  /** 迭  ũ⿡    ִ´.
        stack slot  迭   , Ʒ  ȴ.  */
  unsigned int arraylen;

  /**
        Ǵ union ü.

     @note (20060129)  Ȯ   ʱ ,  ټ 
            ִ.   Ʒ  type  , ӽŸ Ϸ 
           ũⰡ ٸ  ̿  ϵ    ʾ, ٸ
           ӽ Ȥ Ϸ   α׷ ȵư  ٺϴ.
   */
  union
  {
    char _char;                 /**< 1 Ʈ char  .  */
    int _int;                   /**< 4 Ʈ integer  .  */
    void *_addr;                /**< ּ   .  */
  } v;
};

struct ticket;
extern int rovmcore_main (request_rec *, struct ticket *, rc_opcode_t *, rc_size_t);

/**
   @}
*/

#endif
