#include <stdarg.h>

#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "ticket.h"
#include "file.h"

#include "el.h"

/**
   FDS  ǵǾ ִ field  Ŭ CLS   field  Ѵ.

   @param cls    Class   Ŭ  
   @param fds   Field  Ǿ ִ ü .
   @return         ߻ , -1 , ׷   0  ȯϰ
                ȴ.
 */
int
RvDefineFields (RvClass *cls, RvFieldDef *fds)
{
  RvFieldDef *fd = fds;

  while (fd->name)
    {
      RvField *f;

      if (rc_find_efield (cls, (u1 *) fd->name, (u1 *) fd->type))
        return 0;

      f = init_efield (cls, (u1 *) fd->name, (u1 *) fd->type);
      if (!f)
        return -1;

      FIELD_NEXT (f) = CLASS_FIELD (cls);
      CLASS_FIELD (cls) = f;

      fd++;
    }

  return 0;
}

/**
   CLS  MDS  о ش Method  ǵ CLS ο Ѵ.

   @param cls    Class   Ŭ  
   @param mds   Method  Ǿ ִ .
   @return         ߻ , -1 , ׷   0  ȯϰ
                ȴ.
 */
int
RvDefineMethods (RvClass *cls, RvMethodDef *mds)
{
  RvMethodDef *md = mds;

  while (md->name)
    {
      RvMethod * m;

      if (rc_find_emethod (cls, (u1 *) md->name, (u1 *) md->type))
        return 0;

      /* Native Function  ȣ  ֵ method  մϴ.  */
      m = init_emethod ((u1 *) md->name, (u1 *) md->type);
      if (!m)
        return -1;

      METHOD_FLAG (m) |= ACCESS_NATIVE;
      METHOD_NATIVE (m) = md->func;
      METHOD_NEXT (m) = CLASS_METHOD (cls);
      
      CLASS_METHOD (cls) = m;

      md++;
    }

  return 0;
}

/**
   ObjectRef  ڰ Ÿ   ˴ϴ.

   @param self   ObjectRef
   @param idx     index ȣ (ݵ OBJECT_MAX_USERDATA 
                 ۾ƾ մϴ.
   @param value  .
*/
int
RvSetUserData (RvObject *self, int idx, void *value)
{
  if (idx >= OBJECT_MAX_USERDATA)
    return -1;

  OBJECT_USERDATA_IDX (self, idx) = (unsigned long) value;

  return 0;
}

/**
   ObjectRef  ڰ  Ÿ  , Ѵ.

   (ܺ  Լ)

   @param self   ObjectRef
   @param idx    Ÿ index ȣ
   @return      ڰ   ȯմϴ.
*/
void *
RvGetUserData (RvObject *self, int idx)
{
  if (idx >= OBJECT_MAX_USERDATA)
    return NULL;

  return (void *) OBJECT_USERDATA_IDX (self, idx);
}

/**
   ARGS  FMT  Ͽ ش  ùٸ   ִ Ȱ ϴ
   ԼԴϴ.

   (ܺ  Լ)

   @param args  RvValue üԴϴ.  ̰ Stack Slot   ͸
                 ˴ϴ.
   @param fmt   ؼ Դϴ.
   @return        0 , ׷   -1  ȯѴ.
*/
int
RvParseArg (RvValue *args, const char *fmt, ...)
{
  va_list ap;
  int idx;
  char *p = (char *) fmt;

  va_start (ap, fmt);

  idx = 0;
  while (*p)
    {
      switch (*p)
        {
        case 's':
          {
            char **s = va_arg (ap, char **);

            *s = "Under Construction";
            break;
          }
        case 'i':
          {
            int *i = va_arg (ap, int *);
            
            *i = STACK_V_INT (args + idx);
            break;
          }
        default:
          goto error;
          break;
        }

      idx++;
      p++;
    }

  va_end (ap);

  return 0;

 error:
  va_end (ap);

  return -1;
}
