/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_H
#define _ROVM_H

/** ROVM  ⺻ listening port ȣ.  */
#define DEFAULT_ROVM_LISTENING_PORT     4390
#define DEFAULT_ENVLANG_EXTENSION               ".e"
#define DEFAULT_ENVLANG_NATIVE_EXTENSION        ".so"

typedef struct ggc_globals      rc_gc_t;
typedef struct rc_pod_t         rc_pod_t;
/**
   ROVM  ϴ opcode 迭  ŸԴϴ.
 */
typedef unsigned char           rc_opcode_t;

#ifndef MAX_STRING_LEN
/**  MAX_STRING_LEN  ǵǾ   , ̸ Ѵ.  */
#define MAX_STRING_LEN		1024 * 8
#endif

/**
   ROVM   Լ wrapper Լ ,  ũθ δ.  ܼ
    ̱  ġ̴.  ׸ ϰ   ֵ ϱ 
   ؼ ̴.
 */
#define RC_WRAPPER_FUNC

/*
   ROVM Reserved Commands.
 */
#include "command.def"

/**
   ROVM  ߱ϴ ticket  ⺻ ũ⸦ Ų.  
*/
#define TICKETID_SIZE	ROVM_SHA1_DIGESTSIZE

#define PROCREC_POOL(NODE)		((NODE)->pool)
#define PROCREC_PCONF(NODE)		((NODE)->pconf)
#define PROCREC_ARGC(NODE)		((NODE)->argc)
#define PROCREC_ARGV(NODE)		((NODE)->argv)
#define PROCREC_NAME(NODE)		((NODE)->short_name)

/**
   ϳ μ Ÿ ü.
*/
struct process_rec
{
  /** Global pool.  exit  ȴ.  */
  rc_pool_t *pool;
  /**   pool.  ۽  ȴ.  */
  rc_pool_t *pconf;
  /** α׷ ޵ Command  argument  .  */
  int argc;
  /** Command  argument .  */
  const char * const *argv;
  /** α׷ Ǵµ,  α׷ ̸.  */
  const char *short_name;
};

#define CONF_ONE_PROCESS(NODE)          ((NODE)->one_process)
#define CONF_SEND_BUFFER_SIZE(NODE)     ((NODE)->send_buffer_size)
#define CONF_RECEIVE_BUFFER_SIZE(NODE)  ((NODE)->receive_buffer_size)
#define CONF_LISTENBACKLOG(NODE)        ((NODE)->listenbacklog)
#define CONF_PORT(NODE)                 ((NODE)->port)
#define CONF_THREADS_PER_CHILD(NODE)	((NODE)->threads_per_child)
#define CONF_ERROR_LOG(NODE)            ((NODE)->errlog)
#define CONF_LOGLEVEL(NODE)             ((NODE)->loglevel)
#define CONF_OPTION(NODE)               ((NODE)->bit_option)
#define CONF_DEFAULT_STACK_SLOT(NODE)   ((NODE)->default_stack_slot)
#define CONF_CLASSROOT(NODE)            ((NODE)->classroot)

#define OPTION_LOG_DEBUG_MESSAGES       (1 << 1)

/**
   ROVM  ü.
 */
struct rovm_config
{
  /**  ϳ μ  ,   1  Ѵ. ׷ ʴٸ 0 
      Ѵ.  */
  int one_process;

  /* Listen  .  */
  int send_buffer_size;
  int receive_buffer_size;
  int listenbacklog;

  /** Listening   Ʈ ȣ Ѵ.  */
  rc_port_t port;

  /** Child   thread  Ѵ.  */
  int threads_per_child;

  /** Debug ޼  Ͽ  .  */
  FILE *errlog;
  /** ⺻ debug .      α  ˴ϴ.  */
  int loglevel;

  /** ROVM α׷ ɼ ϴ ν, α     
      ֽϴ.  */
  int bit_option;

  /** Ticket   , ⺻   slot  մϴ.  */
  int default_stack_slot;

  /** Class ϵ ϴ 丮 root .  */
  char *classroot;
};

#define STATUS_SHUTDOWN_PENDING(NODE)   ((NODE)->shutdown_pending)
#define STATUS_RESTART_PENDING(NODE)    ((NODE)->restart_pending)

struct rovm_status
{
  int shutdown_pending;
  int restart_pending;
};

#define ROVM_POOL(NODE)                 PROCREC_POOL (ROVM_PROCESS (NODE))
#define ROVM_CONF(NODE)			((NODE)->config)
#define ROVM_STATUS(NODE)               ((NODE)->status)
#define ROVM_PROCESS(NODE)		((NODE)->process)
#define ROVM_POD(NODE)                  ((NODE)->pod)
#define ROVM_LISTENERS(NODE)            ((NODE)->listeners)
#define ROVM_TKTREE(NODE)		((NODE)->tk)
#define ROVM_CLSTREE(NODE)              ((NODE)->cls)
#define ROVM_MUTEX(NODE)                ((NODE)->mutex)
#define ROVM_GC(NODE)                   ((NODE)->gc)
#define ROVM_GC_MUTEX(NODE)             ((NODE)->gc_mutex)

/**
   ROVM  ü ü.
 */
struct rovm
{
  /** ROVM   ü̴.       ִ.  */
  struct rovm_config *config;
  /** ROVM Server  ¿ ؼ ϴ ü.  */
  struct rovm_status *status;

  /**   μ   ִ.  */
  struct process_rec *process;

  /** ROVM  ,  ټ listening port  ó  ֵ
      Ǿ ,  ϳ port  ϹǷ listeners  next 
      NULL  ̴.   ټ port  ϵ   ִ.  */
  rc_listen_rec *listeners;

  /** Pipe-of-Death   .  */
  rc_pod_t *pod;

  /** ROVM Server  Ϲ Ǵ mutex.  */
  rc_thread_mutex_t *mutex;

  /** ü Ticket  ϴ tree ü.  Key  Value  Ǿ ִ.  */
  tktree_t *tk;
  /** ü Class  ϴ tree ü.  */
  clstree_t *cls;

  /** Garbage Collector   ü.  */
  rc_gc_t *gc;
  /** Garbage Collector  ؼ Ǵ mutex.  */
  rc_thread_mutex_t *gc_mutex;
};

#endif
