/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_TYPES_H
#define _ROVM_TYPES_H

#include "apr.h"
#include "apr_allocator.h"
#include "apr_atomic.h"
#include "apr_dso.h"
#include "apr_errno.h"
#include "apr_file_io.h"
#include "apr_lib.h"
#include "apr_network_io.h"
#include "apr_pools.h"
#include "apr_portable.h"
#include "apr_signal.h"
#include "apr_tables.h"
#include "apr_thread_cond.h"
#include "apr_thread_mutex.h"
#include "apr_thread_proc.h"
#include "apr_time.h"
#include "apr_strings.h"
#define APR_WANT_BYTEFUNC
#include "apr_want.h"

/**
   Լ ȯ κ Ǵ type ̸, ش Լ status  ȯϱ
    ˴ϴ.
 */
typedef apr_abortfunc_t         rc_abortfunc_t;
typedef apr_allocator_t         rc_allocator_t;
typedef apr_dso_handle_t        rc_dso_handle_t;
typedef apr_dso_handle_sym_t    rc_dso_handle_sym_t;
typedef apr_file_t              rc_file_t;
typedef apr_int32_t             rc_int32_t;
typedef apr_interval_time_t     rc_interval_time_t;
typedef apr_os_thread_t         rc_os_thread_t;
typedef apr_pool_t              rc_pool_t;
typedef apr_port_t              rc_port_t;
typedef apr_size_t              rc_size_t;
typedef apr_sockaddr_t          rc_sockaddr_t;
typedef apr_socket_t            rc_socket_t;
typedef apr_status_t            rc_status_t;
typedef apr_table_t             rc_table_t;
typedef apr_thread_t            rc_thread_t;
typedef apr_thread_cond_t       rc_thread_cond_t;
typedef apr_thread_mutex_t      rc_thread_mutex_t;
typedef apr_thread_start_t      rc_thread_start_t;
typedef apr_threadattr_t        rc_threadattr_t;
typedef apr_time_t              rc_time_t;
typedef apr_uint32_t            rc_uint32_t;

#define RC_EGENERAL                     APR_EGENERAL
#define RC_EOF                          APR_EOF
#define RC_EINTR                        APR_EINTR
#define RC_ENOTIMPL                     APR_ENOTIMPL
#define RC_INCOMPLETE_READ              APR_INCOMPLETE_READ
#define RC_LOCAL                        APR_LOCAL
#define RC_REMOTE                       APR_REMOTE
#define RC_SHUTDOWN_WRITE               APR_SHUTDOWN_WRITE
#define RC_SO_REUSEADDR                 APR_SO_REUSEADDR
#define RC_SO_KEEPALIVE                 APR_SO_KEEPALIVE
#define RC_SO_SNDBUF                    APR_SO_SNDBUF
#define RC_SO_RCVBUF                    APR_SO_RCVBUF
#define RC_SUCCESS                      APR_SUCCESS
#define RC_THREAD_MUTEX_DEFAULT         APR_THREAD_MUTEX_DEFAULT
#define RC_UNSPEC                       APR_UNSPEC
#define RC_INET                         APR_INET

#define RC_STATUS_IS_EOF(R)             APR_STATUS_IS_EOF (R)
#define RC_STATUS_IS_EINTR(R)           APR_STATUS_IS_EINTR (R)
#define RC_STATUS_IS_TIMEUP(RV)         APR_STATUS_IS_TIMEUP (RV)

#define rc_atomic_casptr                apr_atomic_casptr
#define rc_atomic_cas32                 apr_atomic_cas32
#define rc_atomic_dec32                 apr_atomic_dec32
#define rc_dso_error                    apr_dso_error
#define rc_dso_load                     apr_dso_load
#define rc_dso_sym                      apr_dso_sym
#define rc_file_pipe_create             apr_file_pipe_create
#define rc_file_pipe_timeout_set        apr_file_pipe_timeout_set
#define rc_file_inherit_unset           apr_file_inherit_unset
#define rc_file_read                    apr_file_read
#define rc_file_close                   apr_file_close
#define rc_file_write                   apr_file_write
#define rc_os_sock_get                  apr_os_sock_get
#define rc_pool_cleanup_null            apr_pool_cleanup_null
#define rc_pstrndup                     apr_pstrndup
#define rc_pstrcat                      apr_pstrcat
#define rv_sockaddr_info_get            apr_sockaddr_info_get
#define rc_sockaddr_equal               apr_sockaddr_equal
#define rc_socket_timeout_set           apr_socket_timeout_set
#define rc_socket_connect               apr_socket_connect
#define rc_socket_send                  apr_socket_send
#define rc_signal_thread                apr_signal_thread
#define rc_signal                       apr_signal
#define rc_socket_send                  apr_socket_send
#define rc_socket_recv                  apr_socket_recv
#define rc_socket_close                 apr_socket_close
#define rc_socket_shutdown              apr_socket_shutdown
#define rc_socket_timeout_set           apr_socket_timeout_set
#define rc_socket_close                 apr_socket_close
#define rc_socket_opt_set               apr_socket_opt_set
#define rc_socket_bind                  apr_socket_bind
#define rc_socket_listen                apr_socket_listen
#define rc_sockaddr_info_get            apr_sockaddr_info_get
#define rc_socket_create                apr_socket_create
#define rc_socket_accept                apr_socket_accept
#define rc_socket_addr_get              apr_socket_addr_get
#define rc_sockaddr_ip_get              apr_sockaddr_ip_get
#define rc_table_make                   apr_table_make
#define rc_time_from_sec                apr_time_from_sec
#define rc_time_from_sec                apr_time_from_sec

/** @return rc_time_t  second  usec . */
#define rc_time_make(sec, usec)         apr_time_make (sec, usec)
/** @return usec  rc_time_t */
#define rc_time_usec(time)              apr_time_usec (time)

#include "rovm_config.h"

#endif
