#include <stdlib.h>

#include "types.h"
#include "mpool.h"
#include "clstree.h"
#include "tktree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "log.h"
#include "common.h"
#include "ticket.h"
#include "utils.h"

#include "class.h"

#define EFILE_PATH(NODE)                ((NODE)->filepath)
#define EFILE_BUFBASE(NODE)             ((NODE)->bufbase)
#define EFILE_BUFCUR(NODE)              ((NODE)->bufcur)
#define EFILE_BUFCUR_IDX(NODE, IDX)	((NODE)->bufcur[(IDX)])
#define EFILE_BUFLEN(NODE)              ((NODE)->buflen)

struct efile
{
  /**  óϰ ִ File  .  */
  u1 *filepath;

  u1 *bufbase;
  u1 *bufcur;
  u4 buflen;
};

/**
    EF κ 1 Ʈ C  ϰ, ġ ̵Ѵ.  
*/
static void
readu1 (ef, c)
     struct efile *ef;
     u1 *c;
{
  *c = EFILE_BUFCUR_IDX (ef, 0);
  EFILE_BUFCUR (ef) += 1;
}

/**
   EF κ 1 Ʈ C  ϰ, ġ ̵Ѵ.  
*/
static void 
readu2 (ef, c)
     struct efile *ef;
     u2 *c;
{
  *c = ((u2 *) &EFILE_BUFCUR_IDX (ef, 0))[0];
  EFILE_BUFCUR (ef) += 2;
}

/**
   EF κ 4 Ʈ C  ϰ, ġ ̵Ѵ.  
*/
static void 
readu4 (ef, c)
     struct efile *ef;
     u4 *c;
{
  *c = ((u4 *) (&EFILE_BUFCUR_IDX (ef, 0)))[0];
  EFILE_BUFCUR (ef) += 4;
}

/**
   struct environment_file  LEN*SIZE ŭ о, DEST 
   Ѵ.
*/
static void
readm (ef, dest, len, size)
     struct efile *ef;
     void *dest;
     size_t len;
     size_t size;
{
  int tsize = len * size;

  memcpy (dest, EFILE_BUFCUR (ef), tsize);
  EFILE_BUFCUR (ef) += tsize;
}

/**
   ROVM   ClassRoot  PATH  Ͽ ü θ ϼϿ
   ȯմϴ.

   @param r     ROVM ü
   @param path  Class   
 */
static char *
efile_getfullpath (r, path, postfix)
     struct rovm *r;
     char *path, *postfix;
{
  char *ret;

  if (!r || (r && !CONF_CLASSROOT (ROVM_CONF (r))))
    return NULL;

  ret = (char *) rc_calloc (1, 
                            strlen (CONF_CLASSROOT (ROVM_CONF (r))) 
                            + strlen (path) 
                            + strlen (DEFAULT_ENVLANG_EXTENSION)
                            + 1);
  strcat (ret, CONF_CLASSROOT (ROVM_CONF (r)));
  strcat (ret, path);
  strcat (ret, postfix);

  return ret;
}

/**
    ϴ Ȯ , ̿  ȯ ݴϴ.

   @param r     ROVM ü
   @param path   (Ȯڰ ֽϴ.)
   @param ext   Ȯ
   @return          1  ׷   0  ȯմϴ.
 */
static int
rc_fileexist (r, path, ext)
     struct rovm *r;
     char *path, *ext;
{
  char *fp;
  struct stat fi; 

  fp = efile_getfullpath (r, path, ext);

  if (stat (fp, &fi))
    {
      rc_free (fp);
      return 0;
    }

  rc_free (fp);
  return 1;
}

/**
    PATH  мϰ ٵ,   ϰ  ⺻   Ÿ
   ȯ ϰ,   struct efile ü ȯѴ.

   @param r     ROVM ü
   @param path  Load  Class  .
 */
static struct efile *
init_efile (r, path)
     struct rovm *r;
     char *path;
{
  char *fullpath;
  FILE *fp;
  size_t read_bytes;
  struct efile *ef;

  fullpath = efile_getfullpath (r, path, DEFAULT_ENVLANG_EXTENSION);
  if (!fullpath)
    return NULL;

  if (!(fp = fopen (fullpath, "rb")))
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "fopen error.");
      rc_free (fullpath);
      return NULL;
    }

  if (fseek (fp, 0L, SEEK_END))
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "fseek error.");
      rc_free (fullpath);
      fclose (fp);
      return NULL;
    }

  ef = (struct efile *) rc_malloc (sizeof (struct efile));
  EFILE_PATH (ef) = fullpath;
  EFILE_BUFLEN (ef) = (int) ftell (fp);
  EFILE_BUFBASE (ef) = EFILE_BUFCUR (ef) = (u1 *) rc_malloc (EFILE_BUFLEN (ef));

  fseek (fp, 0L, SEEK_SET);
  read_bytes = fread (EFILE_BUFBASE (ef), 1, EFILE_BUFLEN (ef), fp);
  if (read_bytes != EFILE_BUFLEN (ef))
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "fread error.");
      rc_free (EFILE_BUFBASE (ef));
      rc_free (fullpath);
      rc_free (ef);
      fclose (fp);
      return NULL;
    }

  fclose (fp);

  return ef;
}

/**
    ̻  ʴ struct efile ü մϴ.

   @param ef     ǽ ü.
 */
static void
finish_efile (ef)
     struct efile *ef;
{
  rc_free (EFILE_PATH (ef));
  rc_free (EFILE_BUFBASE (ef));
  rc_free (ef);
}

/**
   RvClass ü Ӱ ҴϿ ش ͸ ȯѴ.
   
   @return      Ӱ Ҵ RvClass ü.
 */
static RvClass *
init_eclass (r)
     struct rovm *r;
{
  RvClass *cls;

  cls = (RvClass *) rc_calloc (1, sizeof (RvClass));
  CLASS_ROVM (cls) = r;

  return cls;
}

/**
   RvField  ıմϴ.

   @param m     ı field.
 */
static void
destroy_efield (f)
     RvField *f;
{
#define FIELDFREE(NODE)                         \
  if ((NODE))                                   \
    rc_free ((NODE))
  
  FIELDFREE (FIELD_NAME (f));
  FIELDFREE (FIELD_TYPE (f));

  rc_free (f); 
}

/**
   RvMethod  ıմϴ.

   @param m     ı method.
 */
static void
destroy_emethod (m)
     RvMethod *m;
{
#define METHODFREE(NODE)                        \
  if ((NODE))                                   \
    rc_free ((NODE))
  
  METHODFREE (METHOD_NAME (m));
  if (METHOD_TYPE (m))
    {
      METHODFREE (MTYPE_STR (METHOD_TYPE (m)));
      METHODFREE (MTYPE_ARGV (METHOD_TYPE (m)));
      rc_free (METHOD_TYPE (m));
    }
  METHODFREE (METHOD_OP (m));
  rc_free (m); 
}

/**
   RvClass ü  Ѵ.

   @param cls    RvClass ü 
 */
static void
destroy_eclass (cls)
     RvClass *cls;
{
#define CLSFREE(NODE) \
  if ((NODE))         \
    rc_free ((NODE))

  if (!cls)
    return;

  CLSFREE (CLASS_NAME (cls));

  if (CLASS_METHOD (cls))
    {
      RvMethod *next, *m = CLASS_METHOD (cls);

      while (m)
        {
          next = METHOD_NEXT (m);

          destroy_emethod (m);

          m = next;
        }
    }

  rc_free (cls);
}

/**
   Ŭ CLS  field  NAME  TYPE    ã ȯѴ.

   @param cls   Ŭ 
   @param name  ã field ̸
   @param type  ã Ÿ ̸
   @return      ã field , ߰ Ͽ , NULL_FIELD  ȯմϴ.
 */
RvField *
rc_find_efield (cls, name, type)
     RvClass *cls;
     u1 *name, *type;
{
  RvField *m;

  if (!cls || !name || !type)
    return NULL_FIELD;

  m = CLASS_FIELD (cls);

  while (m)
    {
      if (!strcmp (FIELD_NAME (m), name)
          && !strcmp (FIELD_TYPE (m), type))
        return m;

      m = FIELD_NEXT (m);
    }

  return NULL_FIELD;
}

/**
   Ŭ CLS  ޽  NAME  TYPE    ã ȯѴ.

   @param cls   Ŭ 
   @param name  ã ޽ ̸
   @param type  ã Ÿ ̸
   @return      ã ޽, ߰ Ͽ , NULL_METHOD  ȯմϴ.
 */
RvMethod *
rc_find_emethod (cls, name, type)
     RvClass *cls;
     u1 *name, *type;
{
  RvMethod *m;

  if (!cls || !name || !type)
    return NULL_METHOD;

  m = CLASS_METHOD (cls);

  while (m)
    {
      if (!strcmp (METHOD_NAME (m), name)
          && METHOD_TYPE (m)
          && !strcmp (MTYPE_STR (METHOD_TYPE (m)), type))
        return m;

      m = METHOD_NEXT (m);
    }

  return NULL_METHOD;
}

/**
   Method Type  TYPE  ؼϿ Argument   ȯѴ.

   @param type  ؼ Method Type ڿ
   @return      ؼ argument  
 */
u2
calctype_argc (path)
     u1 *path;
{
  int idx = 0;
  u1 *p = path;

  while (*p != '\0')
    {
      switch (*p)
        {
        case '[':
        case 'B':
        case 'C':
        case 'H':
        case 'I':
        case 'F':
        case 'D':
        case 'T':
        case 'S':
          idx++;
          break;
        case '(':
          break;
        case ')':
          return idx;
          break;
        default:
          rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Can't handle type = `%c'", *p);
          break;
        }
      p++;
    }

  /*  ϸ ̴.  */
  return 0xffff;
}

/**
   Method Type  TYPE  ؼϿ  Argument  offset  Ͽ ش
   迭 ȯϰ ˴ϴ.

   @param type  ؼ Method Type ڿ
   @param argc   Method Type  argument 
   @return      ؼ argument  offset   迭
 */
u2 *
calctype_argv (type, argc)
     u1 *type;
     u2 argc;
{
  int idx = 0;
  u1 *p = type;
  u2 *argv = (u2 *) rc_malloc (sizeof (u2) * argc);

  if (!argv)
    return NULL;

  while (*p != '\0')
    {
      switch (*p)
        {
        case '[':
        case 'B':
        case 'C':
        case 'H':
        case 'I':
        case 'F':
        case 'D':
        case 'T':
        case 'S':
          argv[idx++] = (u2) (p - type);
          break;
        case '(':
          break;
        case ')':
          return argv;
          break;
        default:
          rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Can't handle type = `%c'", *p);
          break;
        }
      p++;
    }

  /*  ϸ ̴.  */
  rc_free (argv);

  return NULL;
}

/**
   Method Type  TYPE  ؼϿ return  ִ ڿ  offset 
   ȯմϴ.

   @param type  ؼ Method Type ڿ
   @return      ؼ return  offset .    ִٸ -1 
                ȯϰ ˴ϴ.
 */
static u2
calctype_ret (type)
     u1 *type;
{
  u1 *p = type;

  while (*p != '\0')
    {
      switch (*p)
        {
        case '[':
        case 'B':
        case 'C':
        case 'H':
        case 'I':
        case 'F':
        case 'D':
        case 'T':
        case 'S':
        case '(':
          break;
        case ')':
          return (p - type) + 1;
          break;
        default:
          rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Can't handle type = `%c'", *p);
          break;
        }
      p++;
    }

  /*  ϸ ̴.  */
  return 0xffff;
}

/**
   Method  Type  ʱȭ  Ǵ Լν, TYPE   
   Ҵ  ش Ÿ ؼϿ   մϴ.

   @param type  ؼ type
   @return      Ӱ  Method Type 
 */
static struct eclass_method_type *
init_emethodtype (type)
     u1 *type;
{
  struct eclass_method_type *mt;

  if (!type || (type && type[0] != '('))
    return NULL;

  mt = (struct eclass_method_type *) rc_malloc (sizeof (struct eclass_method_type));
  MTYPE_STR (mt) = type;
  MTYPE_ARGC (mt) = calctype_argc (type);
  if (MTYPE_ARGC (mt) == 0xffff)
    {
      rc_free (mt);
      return NULL;
    }
    
  MTYPE_ARGV (mt) = calctype_argv (type, MTYPE_ARGC (mt));
  if (!MTYPE_ARGV (mt))
    {
      rc_free (mt);
      return NULL;
    }

  MTYPE_RET (mt) = calctype_ret (type);
  if (MTYPE_RET (mt) == 0xffff)
    {
      rc_free (MTYPE_ARGV (mt));
      rc_free (mt);
      return NULL;
    }

  return mt;
}

/**
   RvField ü Ӱ ҴϿ ش ͸ ȯѴ.
   
   @return      Ӱ Ҵ RvField ü.
*/
RvField *
init_efield (cls, name, type)
     RvClass *cls;
     u1 *name, *type;
{
  RvField *f;

  f = (RvField *) rc_calloc (1, sizeof (RvField));
  FIELD_NAME (f) = name;
  FIELD_TYPE (f) = type;
  FIELD_INDEX (f) = CLASS_FIELD_COUNT (cls)++;

  return f;
}

/**
   RvMethod ü Ӱ ҴϿ ش ͸ ȯѴ.
   
   @return      Ӱ Ҵ RvMethod ü.
 */
RvMethod *
init_emethod (name, type)
     u1 *name, *type;
{
  RvMethod *m;

  m = (RvMethod *) rc_calloc (1, sizeof (RvMethod));
  METHOD_NAME (m) = name;
  METHOD_TYPE (m) = init_emethodtype (type);
  if (!METHOD_TYPE (m))
    {
      rc_free (m);
      return NULL_METHOD;
    }

  return m;
}

/** Ӽ ClassName  쿡  type Դϴ.  */
#define ATTRIBUTE_CLASSNAME     0xff
/** Ӽ Method  쿡  type Դϴ.  */
#define ATTRIBUTE_METHOD        0xfe
/** Ӽ MethodCode  쿡  type Դϴ.  */
#define ATTRIBUTE_METHODCODE    0xfd
/** Ӽ Field  쿡  type Դϴ.  */
#define ATTRIBUTE_FIELD         0xfc

/**
   EF κ ϳ attribute  о CLS  ϰ ȴ.
 */
static int
rc_read_attribute (r, arg, ef)
     struct rovm *r;
     void *arg;
     struct efile *ef;
{
  int i;
  u1 attribute_type;
  u4 attribute_length;
  
  readu1 (ef, &attribute_type);
  readu4 (ef, &attribute_length);

  /*
     Ӽ  ڼ  http://envlang.kldp.net/ Ȩ ϴ
     `ENVLANG  '  Ͻñ ٶϴ.
   */
  switch (attribute_type)
    {
    case ATTRIBUTE_CLASSNAME:
      {
        u1 name_len, *name;
        RvClass *cls = (RvClass *) arg;

        readu1 (ef, &name_len);
        name = (u1 *) rc_malloc (name_len + 1);
        readm (ef, name, name_len, 1);
        name[name_len] = '\0';

        if (CLASS_NAME (cls))
          {
            rc_free (name);
            goto error;
          }

        CLASS_NAME (cls) = name;
        break;
      }
    case ATTRIBUTE_FIELD:
      {
        u1 name_len, *name, *type;
        u2 type_len, attribute_counts;
        u2 RESERVED_SPACE;
        RvClass *cls = (RvClass *) arg;
        RvField *f;

        readu2 (ef, &RESERVED_SPACE);
        
        readu1 (ef, &name_len);
        name = (u1 *) rc_malloc (name_len + 1);
        readm (ef, name, name_len, 1);
        name[name_len] = '\0';

        readu2 (ef, &type_len);
        type = (u1 *) rc_malloc (type_len + 1);
        readm (ef, type, type_len, 1);
        type[type_len] = '\0';

        if (rc_find_efield (cls, name, type))
          {
            rc_free (type);
            rc_free (name);
            goto error;
          }

        f = init_efield (cls, name, type);
        if (!f)
          {
            rc_free (type);
            rc_free (name);
            goto error;
          }
        readu2 (ef, &attribute_counts);
        for (i=0; i<attribute_counts; i++)
          {
            if (rc_read_attribute (r, (void *) f, ef))
              {
                destroy_efield (f);
                goto error;
              }
          }

        FIELD_NEXT (f) = CLASS_FIELD (cls);
        CLASS_FIELD (cls) = f;
        break;
      }
    case ATTRIBUTE_METHOD:
      {
        u1 name_len, *name, *type;
        u2 type_len, attribute_counts;
        u4 RESERVED_SPACE;
        RvClass *cls = (RvClass *) arg;
        RvMethod *m;

        readu4 (ef, &RESERVED_SPACE);
        
        readu1 (ef, &name_len);
        name = (u1 *) rc_malloc (name_len + 1);
        readm (ef, name, name_len, 1);
        name[name_len] = '\0';

        readu2 (ef, &type_len);
        type = (u1 *) rc_malloc (type_len + 1);
        readm (ef, type, type_len, 1);
        type[type_len] = '\0';

        if (rc_find_emethod (cls, name, type))
          {
            rc_free (type);
            rc_free (name);
            goto error;
          }

        m = init_emethod (name, type);
        if (!m)
          {
            rc_free (type);
            rc_free (name);
            goto error;
          }
        readu2 (ef, &attribute_counts);
        for (i=0; i<attribute_counts; i++)
          {
            if (rc_read_attribute (r, (void *) m, ef))
              {
                destroy_emethod (m);
                goto error;
              }
          }

        METHOD_NEXT (m) = CLASS_METHOD (cls);
        CLASS_METHOD (cls) = m;
        break;
      }
    case ATTRIBUTE_METHODCODE:
      {
        rc_opcode_t *code;
        u2 attribute_counts, max_locals, RESERVED_SPACE;
        u4 code_length;
        RvMethod *m = (RvMethod *) arg;

        readu2 (ef, &RESERVED_SPACE);
        readu2 (ef, &max_locals);

        readu4 (ef, &code_length);
        code = (rc_opcode_t *) rc_malloc (code_length);
        readm (ef, code, code_length, 1);

        readu2 (ef, &RESERVED_SPACE);

        METHOD_MAX_LOCALS (m) = max_locals;
        METHOD_OPLEN (m) = code_length;
        METHOD_OP (m) = code;

        readu2 (ef, &attribute_counts);
        for (i=0; i<attribute_counts; i++)
          {
            if (rc_read_attribute (r, (void *) m, ef))
              goto error;
          }
        break;
      }
    default:
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Invalid Attribute Type : 0x%x", attribute_type);
      return -1;
      /* not reach. */ 
      break;
    }

  return 0;

 error:
  return -1;
}

/**
    EF ü ̿Ͽ ϳ   мϿ д´.

   @param r     ROVM ü
   @param ef    struct efile ü.
 */
static RvClass *
rc_load_classfile_core (r, ef)
     struct rovm *r;
     struct efile *ef;
{
  int i;
  u2 fileformat_version, attribute_counts;
  u4 magic, made_time;
  RvClass *cls;
  
  readu4 (ef, &magic);
  if (magic != 0x0e0a0209)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Invalid Magic Number");
      return NULL_CLASS;
    }

  readu2 (ef, &fileformat_version);
  if (fileformat_version != 0x0002)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "Only supports v0.2 file format version");
      return NULL_CLASS;
    }

  readu4 (ef, &made_time);

  cls = init_eclass (r);

  readu2 (ef, &attribute_counts);
  for (i=0; i<attribute_counts; i++)
    {
      if (rc_read_attribute (r, cls, ef))
        {
          destroy_eclass (cls);
          return NULL_CLASS;
        }
    }

  return cls;
}

/**
   PATH  module  Լ ̸   ̸ ȯѴ.

   @param r     ROVM ü
   @param path   Class  .
 */
char *
rc_getmodname (r, path)
     struct rovm *r;
     char *path;
{
  char *ret, *p;

  p = strrchr (path, '/');
  if (!p)
    return NULL;

  p++;

  ret = (char *) rc_calloc (1, 5 + strlen (p) + 1);
  if (!ret)
    return NULL;

  strcat (ret, "init_");
  strcat (ret, p);

  return ret;
}

/**
   Class  (ENVLANG   ƴ϶,  ̺귯  )  εϿ 
   ׿  Ŭ ͸ ȯմϴ.
 */
RvClass *
rc_load_class_module (r, path)
     struct rovm *r;
     char *path;
{
  RvClass *cls;
  rc_dso_handle_t *modhandle;
  rc_dso_handle_sym_t modsym;
  int (*modfunc) (RvClass *);
  char *fullpath, *modname;

  fullpath = efile_getfullpath (r, path, DEFAULT_ENVLANG_NATIVE_EXTENSION);
  if (!fullpath)
    return NULL_CLASS;

  modname = rc_getmodname (r, path);
  if (!modname)
    {
      rc_free (fullpath);
      return NULL_CLASS;
    }

  /* ش  ROVM ּҷ load  մϴ.  */
  if (rc_dso_load (&modhandle, fullpath, ROVM_POOL (r)) != RC_SUCCESS) 
    {
      char *msg, my_error[256];

      msg = rc_pstrcat (ROVM_POOL (r), "Cannot load ", fullpath,
                        " into server: ",
                        rc_dso_error (modhandle, my_error, sizeof (my_error)),
                        NULL);

      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "%s", msg);
      goto error;
    }

  rovm_log (NULL, ROVMLOG_DEBUG, ROVMLOG_MARK, "loaded module path `%s'", path);

  /*    Լ ͸ ͼ ش Լ ȣմϴ.  */
  if (rc_dso_sym (&modsym, modhandle, modname) != RC_SUCCESS) 
    {
      char *msg, my_error[256];
      
      msg = rc_pstrcat (ROVM_POOL (r), "Can't locate API module function `",
                        modname, "' in file ", fullpath, ": ",
                        rc_dso_error (modhandle, my_error, sizeof(my_error)),
                        NULL);
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "%s", msg);
      goto error;
    }

  modfunc = (void *) modsym;  

  /*  ش Լ .  */
  cls = init_eclass (r);
  CLASS_FLAG (cls) |= ACCESS_NATIVE;
  CLASS_NAME (cls) = rc_strdup (path);
  CLASS_NATIVE_HANDLE (cls) = modhandle;

  if (modfunc (cls))
    goto error;

  rc_free (fullpath);
  rc_free (modname);

  return cls;

 error:

  rc_free (fullpath);
  rc_free (modname);

  return NULL_CLASS;
}

/**
   Class  PATH  о εϰ, ׿   Class ͸
   ȯϰ ˴ϴ.

    ε   ߻ , NULL_CLASS  ȯǰ ˴ϴ.

   @param r     ROVM ü
   @param path  ε带 ϰ   .  ̰ * * ̴.
 */
RvClass *
rc_load_classfile (r, path)
     struct rovm *r;
     char *path;
{
  RvClass *cls;
  struct efile *ef;

  if (!r || !path || (path && path[0] != '/'))
    return NULL_CLASS;

  if (rc_fileexist (r, path, DEFAULT_ENVLANG_EXTENSION))
    {
      ef = init_efile (r, path);
      if (!ef)
        return NULL_CLASS;
      
      cls = rc_load_classfile_core (r, ef);
      
      finish_efile (ef);
    }
  else if (rc_fileexist (r, path, DEFAULT_ENVLANG_NATIVE_EXTENSION))
    cls = rc_load_class_module (r, path);

  return cls;
}
