/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_MPM_WORKER_FDQUEUE_H
#define _ROVM_MPM_WORKER_FDQUEUE_H

typedef struct fd_queue_info_t fd_queue_info_t;

extern rc_status_t rc_queue_info_create (fd_queue_info_t **, rc_pool_t *, int);
extern rc_status_t rc_queue_info_set_idle (fd_queue_info_t *, rc_pool_t *);
extern rc_status_t rc_queue_info_wait_for_idler (fd_queue_info_t *, rc_pool_t **);
extern rc_status_t rc_queue_info_term (fd_queue_info_t *);

struct fd_queue_elem_t 
{
  rc_socket_t *sd;
  rc_pool_t *p;
};
typedef struct fd_queue_elem_t fd_queue_elem_t;

struct fd_queue_t 
{
  fd_queue_elem_t *data;
  int nelts;
  int bounds;
  rc_thread_mutex_t *one_big_mutex;
  rc_thread_cond_t *not_empty;
  int terminated;
};
typedef struct fd_queue_t fd_queue_t;

rc_status_t rc_queue_init (fd_queue_t *, int, rc_pool_t *);
rc_status_t rc_queue_push (fd_queue_t *, rc_socket_t *, rc_pool_t *);
rc_status_t rc_queue_pop (fd_queue_t *, rc_socket_t **, rc_pool_t **);
rc_status_t rc_queue_interrupt_all (fd_queue_t *);
rc_status_t rc_queue_term (fd_queue_t *);

#endif
