#include "rovm.h"

int
ri_ssl_socket_send (rovm_t *r, char *buf, int *size)
{
  int rc;

  rc = SSL_write (r->ssl, buf, *size);
  switch (SSL_get_error (r->ssl, rc))
    {
    case SSL_ERROR_NONE:
      if(*size != rc)
        {
          rovmi_log (r, ROVMLOG_ERR, ROVMLOG_MARK, "Incomplete write!");
          return -1;
        }
      break;
    default:
      rovmi_log (r, ROVMLOG_ERR, ROVMLOG_MARK, "SSL write problem");
      return -1;
    }

  *size = rc;

  return 0;
}

int
ri_ssl_socket_recv (rovm_t *r, char *buf, int *size)
{
  int rc;

  rc = SSL_read (r->ssl, buf, *size);
  switch (SSL_get_error (r->ssl, rc))
    {
    case SSL_ERROR_NONE:
      break;
    case SSL_ERROR_ZERO_RETURN:
      return -1;
    case SSL_ERROR_SYSCALL:
      rovmi_log (r, ROVMLOG_WARNING, ROVMLOG_MARK, "SSL Error: Premature close");
      r->need_shutdown = 1;
      return -1;
    default:
      rovmi_log (r, ROVMLOG_WARNING, ROVMLOG_MARK, "SSL read problem");
      return -1;
    }

  *size = rc;

  return 0;
}

static int 
password_cb (char *buf,int num, int rwflag,void *userdata)
{
  rovm_t *r = (rovm_t *) userdata;

  if (num < strlen (r->pass) + 1)
    return 0;

  strcpy (buf, r->pass);
  return strlen (r->pass);
}

int
ri_ssl_initialize_ctx (r, keyfile, password)
     rovm_t *r;
     const char *keyfile, *password;
{
  SSL_METHOD *meth;

  if (!r->bio_err)
    {
      /* Global system initialization*/
      SSL_library_init ();
      SSL_load_error_strings ();

      /* An error write context */
      r->bio_err = BIO_new_fp (stderr, BIO_NOCLOSE);
    }

  /* Create our context*/
  meth = SSLv23_method ();
  r->ctx = SSL_CTX_new (meth);

  /* Load our keys and certificates*/
  if(!(SSL_CTX_use_certificate_chain_file (r->ctx, keyfile)))
    {
      rovmi_log (r, ROVMLOG_ERR, ROVMLOG_MARK, "Can't read certificate file");
      return -1;
    }

  r->pass = apr_pstrdup (r->p, password);
  SSL_CTX_set_default_passwd_cb (r->ctx, password_cb);
  SSL_CTX_set_default_passwd_cb_userdata (r->ctx, (void *) r);
  if(!(SSL_CTX_use_PrivateKey_file (r->ctx, keyfile, SSL_FILETYPE_PEM)))
    {
      rovmi_log (r, ROVMLOG_ERR, ROVMLOG_MARK, "Can't read key file");
      return -1;
    }

#if 0
  /* Load the CAs we trust*/
  if(!(SSL_CTX_load_verify_locations (r->ctx, CA_LIST,0)))
    {
      rovmi_log (r, ROVMLOG_ERR, ROVMLOG_MARK, "Can't read CA list");
      return -1;
    }
#endif
  
#if (OPENSSL_VERSION_NUMBER < 0x00905100L)
  SSL_CTX_set_verify_depth(r->ctx, 1);
#endif
  
  return 0;
}

int
ri_ssl_connect (r)
     rovm_t *r;
{
  int sock;
  BIO *sbio;

  apr_os_sock_get (&sock, r->sock);

  r->ssl = SSL_new (r->ctx);
  sbio = BIO_new_socket (sock, BIO_NOCLOSE);
  SSL_set_bio (r->ssl, sbio, sbio);
  if (r->sess)
    SSL_set_session (r->ssl, r->sess);
  if (SSL_connect (r->ssl) <= 0)
    {
      rovmi_log (r, ROVMLOG_ERR, ROVMLOG_MARK, "SSL connect error");
      return -1;
    }

  return 0;
}

int
ri_ssl_destory (r)
     rovm_t *r;
{
  int rc;

  if (!r->sess)
    r->sess = SSL_get1_session (r->ssl);

  if (r->need_shutdown)
    {
      rc = SSL_shutdown (r->ssl);
      switch (rc)
        {
        case 1:
          break; /* Success */
        case 0:
        case -1:
        default:
          rovmi_log (r, ROVMLOG_ERR, ROVMLOG_MARK, "Shutdown failed");
          break;
        }
      r->need_shutdown = 0;
    }
  
  if (r->ssl)
    {
      SSL_free (r->ssl);
      r->ssl = NULL;
    }
  if (r->ctx)
    {
      SSL_CTX_free (r->ctx);
      r->ctx = NULL;
    }

  return 0;
}
