<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 Yun-young Lee
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: db.pgsql.php,v 1.7.2.2 2004/02/04 07:06:51 lseeker Exp $
 */

require_once('lib/db.common.php');

$db['dbms'] = 'PostgreSQL';

class DB extends DBcommon {
    function &connect($host, $user, $pass, $name) {
        $connhost = empty($host) ? '' : "host='{$host}'";
        $connpass = empty($pass) ? '' : "password='{$pass}'";

        if ( ($dbconn = @pg_connect("{$connhost} user='{$user}' {$connpass} dbname='{$name}'")) === FALSE) {
            DB::error('Connect Error', 'PostgreSQL 서버에 접속할 수 없습니다.');
        }

        return $dbconn;
    }

    function &query($command, &$dbconn) {
        return @pg_query($dbconn, $command);
    }

    function &fetch(&$result) {
        return pg_fetch_assoc($result);
    }

    function &result(&$result, $row, $column) {
        return pg_fetch_result($result, $row, $column);
    }

    function &numrows(&$result) {
        return pg_num_rows($result);
    }

    function close(&$dbconn) {
        pg_close($dbconn);
    }

    function begin(&$dbconn) {
        pg_query($dbconn, 'BEGIN');
    }

    function commit(&$dbconn) {
        pg_query($dbconn, 'COMMIT');
    }

    function &getinsertidx(&$dbconn) {
        return pg_fetch_result(pg_query($dbconn, 'SELECT currval(\'hboard_db_article_idx_seq\')'), 0, 0);
    }
}
?>
